/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.rest.internal;

import com.sonatype.nexus.blobstore.azure.internal.AzureConfigurationConstants;
import com.sonatype.nexus.blobstore.azure.rest.internal.model.AzureBlobStoreApiAuthentication;
import com.sonatype.nexus.blobstore.azure.rest.internal.model.AzureBlobStoreApiBucketConfiguration;
import com.sonatype.nexus.blobstore.azure.rest.internal.model.AzureBlobStoreApiModel;
import java.util.Objects;
import java.util.function.Function;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.rest.BlobStoreApiSoftQuota;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.rapture.PasswordPlaceholder;

public final class AzureBlobStoreApiConfigurationMapper {
    static final Function<BlobStoreConfiguration, AzureBlobStoreApiModel> CONFIGURATION_MAPPER = configuration -> new AzureBlobStoreApiModel(configuration.getName(), AzureBlobStoreApiConfigurationMapper.createSoftQuota(configuration), AzureBlobStoreApiConfigurationMapper.createBucketConfiguration(configuration.attributes(AzureConfigurationConstants.CONFIG_KEY)));

    private static BlobStoreApiSoftQuota createSoftQuota(BlobStoreConfiguration configuration) {
        NestedAttributesMap softQuotaAttributes = configuration.attributes("blobStoreQuotaConfig");
        if (!softQuotaAttributes.isEmpty()) {
            BlobStoreApiSoftQuota blobStoreApiSoftQuota = new BlobStoreApiSoftQuota();
            String quotaType = AzureBlobStoreApiConfigurationMapper.getValue(softQuotaAttributes, "quotaType");
            String quotaLimit = AzureBlobStoreApiConfigurationMapper.getValue(softQuotaAttributes, "quotaLimitBytes");
            if (Objects.nonNull(quotaType) && Objects.nonNull(quotaLimit)) {
                blobStoreApiSoftQuota.setType(quotaType);
                blobStoreApiSoftQuota.setLimit(Long.valueOf(Long.parseLong(quotaLimit)));
                return blobStoreApiSoftQuota;
            }
        }
        return null;
    }

    private static AzureBlobStoreApiBucketConfiguration createBucketConfiguration(NestedAttributesMap attributes) {
        return new AzureBlobStoreApiBucketConfiguration(AzureBlobStoreApiConfigurationMapper.getValue(attributes, "accountName"), AzureBlobStoreApiConfigurationMapper.getValue(attributes, "containerName"), AzureBlobStoreApiConfigurationMapper.createAuthenticationConfiguration(attributes));
    }

    private static AzureBlobStoreApiAuthentication createAuthenticationConfiguration(NestedAttributesMap attributes) {
        return new AzureBlobStoreApiAuthentication(AzureBlobStoreApiConfigurationMapper.getValue(attributes, "authenticationMethod"), PasswordPlaceholder.get());
    }

    private static String getValue(NestedAttributesMap attributes, String key) {
        return Objects.toString(attributes.get(key), null);
    }
}

