/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.rest;

import com.google.common.annotations.VisibleForTesting;
import com.sonatype.nexus.blobstore.azure.AzureConnectionChecker;
import com.sonatype.nexus.blobstore.azure.internal.AzureConfigurationConstants;
import com.sonatype.nexus.blobstore.azure.rest.AzureConnectionXO;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.rapture.PasswordPlaceholder;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@Path(value="/internal/ui/azureblobstore")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AzureBlobStoreUIResource
extends ComponentSupport
implements Resource {
    static final String RESOURCE_URI = "/internal/ui/azureblobstore";
    private final AzureConnectionChecker azureConnectionChecker;
    private final BlobStoreManager blobStoreManager;

    @Inject
    public AzureBlobStoreUIResource(AzureConnectionChecker azureConnectionChecker, BlobStoreManager blobStoreManager) {
        this.azureConnectionChecker = azureConnectionChecker;
        this.blobStoreManager = blobStoreManager;
    }

    @POST
    @Path(value="test-connection")
    @RequiresAuthentication
    @Validate
    public void verifyConnection(@NotNull @Valid AzureConnectionXO azureConnectionXO) {
        this.verify(azureConnectionXO);
    }

    @POST
    @Path(value="test-connection/{blobStoreName}")
    @RequiresAuthentication
    @Validate
    public void verifyConnection(@PathParam(value="blobStoreName") String blobStoreName, @NotNull @Valid AzureConnectionXO azureConnectionXO) {
        if (PasswordPlaceholder.is((String)azureConnectionXO.getAccountKey())) {
            azureConnectionXO.setAccountKey(this.retrieveAccountKey(blobStoreName));
        }
        this.verify(azureConnectionXO);
    }

    private void verify(AzureConnectionXO azureConnectionXO) {
        try {
            this.azureConnectionChecker.verifyConnection(azureConnectionXO.getAccountName(), azureConnectionXO.getAccountKey(), azureConnectionXO.getContainerName(), azureConnectionXO.getAuthenticationMethod());
        }
        catch (Exception e) {
            this.log.warn("Can't connect to blob store", (Throwable)e);
            throw new WebApplicationException("Can't connect to blob store", 400);
        }
    }

    @VisibleForTesting
    String retrieveAccountKey(String blobStoreName) {
        return (String)((Map)this.blobStoreManager.get(blobStoreName).getBlobStoreConfiguration().getAttributes().get(AzureConfigurationConstants.CONFIG_KEY)).get("accountKey");
    }
}

