/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.rest;

import com.sonatype.nexus.blobstore.azure.AzureConnectionChecker;
import com.sonatype.nexus.blobstore.azure.rest.AzureBlobStoreResourceDoc;
import com.sonatype.nexus.blobstore.azure.rest.AzureConnectionXO;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.validation.Validate;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AzureBlobStoreResource
extends ComponentSupport
implements Resource,
AzureBlobStoreResourceDoc {
    private final AzureConnectionChecker azureConnectionChecker;

    public AzureBlobStoreResource(AzureConnectionChecker azureConnectionChecker) {
        this.azureConnectionChecker = azureConnectionChecker;
    }

    @Override
    @POST
    @Path(value="test-connection")
    @RequiresAuthentication
    @Validate
    public void verifyConnection(@NotNull @Valid AzureConnectionXO azureConnectionXO) {
        try {
            this.azureConnectionChecker.verifyConnection(azureConnectionXO.getAccountName(), azureConnectionXO.getAccountKey(), azureConnectionXO.getContainerName(), azureConnectionXO.getAuthenticationMethod());
        }
        catch (Exception e) {
            this.log.warn("Can't connect to blob store", (Throwable)e);
            throw new WebApplicationException("Can't connect to blob store", 400);
        }
    }
}

