/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.internal.db.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.sonatype.nexus.blobstore.azure.internal.DeletedBlobIndex;
import com.sonatype.nexus.blobstore.azure.internal.db.orient.BlobIdEntity;
import com.sonatype.nexus.blobstore.azure.internal.db.orient.OrientDeletedBlobEntityAdapter;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orientDeletedBlobIndex")
@Priority(value=0x7FFFFFFF)
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
public class OrientDeletedBlobIndex
extends StateGuardLifecycleSupport
implements DeletedBlobIndex {
    public static final String NAME = "orientDeletedBlobIndex";
    private final OrientDeletedBlobEntityAdapter adapter;
    private final Provider<DatabaseInstance> database;

    @Inject
    public OrientDeletedBlobIndex(OrientDeletedBlobEntityAdapter adapter, @Named(value="component") @Named(value="component") Provider<DatabaseInstance> database) {
        this.adapter = (OrientDeletedBlobEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)adapter)));
        this.database = (Provider)Preconditions.checkNotNull(database);
    }

    protected void doStart() throws Exception {
        super.doStart();
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.database.get()).connect();){
            this.adapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void add(String blobstore, BlobId blobId) {
        BlobIdEntity blobIdEntity = this.adapter.newEntity();
        blobIdEntity.setBlobstore(blobstore);
        blobIdEntity.setBlobId(blobId.asUniqueString());
        OrientTransactional.inTxRetry(this.database).run(db -> {
            ODocument oDocument = this.adapter.addEntity(db, (Entity)blobIdEntity);
        });
    }

    @Override
    public void remove(BlobId blobId) {
        OrientTransactional.inTxRetry(this.database).run(db -> {
            boolean bl = this.adapter.delete(db, blobId);
        });
    }

    @Override
    public Stream<BlobId> browse(String blobstore) {
        return (Stream)OrientTransactional.inTxRetry(this.database).call(db -> ImmutableList.copyOf((Iterable)this.adapter.browse(db)).stream().filter(entity -> entity.getBlobstore().equals(blobstore)).map(entity -> new BlobId(entity.getBlobId())));
    }
}

