/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.internal.db.orient;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.sonatype.nexus.blobstore.azure.internal.db.orient.BlobIdEntity;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.DeleteEntityByPropertyAction;

@Named
@Singleton
public class OrientDeletedBlobEntityAdapter
extends IterableEntityAdapter<BlobIdEntity> {
    static String DB_CLASE_TYPE = "deleted_blob_index";
    private static final String DB_CLASS = new OClassNameBuilder().type(DB_CLASE_TYPE).build();
    private static final String P_BLOBSTORE = "blobstore";
    private static final String P_BLOB_ID = "blob_id";
    private static final String I_BLOBSTORE_BLOB_ID = new OIndexNameBuilder().type(DB_CLASS).property("blobstore").property("blob_id").build();
    private final DeleteEntityByPropertyAction delete = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"blob_id"});

    @Inject
    public OrientDeletedBlobEntityAdapter() {
        super(DB_CLASS);
    }

    protected BlobIdEntity newEntity() {
        return new BlobIdEntity();
    }

    protected void readFields(ODocument document, BlobIdEntity entity) {
        entity.setBlobstore((String)document.field(P_BLOBSTORE, OType.STRING));
        entity.setBlobId((String)document.field(P_BLOB_ID, OType.STRING));
    }

    protected void writeFields(ODocument document, BlobIdEntity entity) {
        document.field(P_BLOBSTORE, (Object)entity.getBlobstore());
        document.field(P_BLOB_ID, (Object)entity.getBlobId());
    }

    protected void defineType(OClass type) {
        type.createProperty(P_BLOBSTORE, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_BLOB_ID, OType.STRING).setMandatory(true).setNotNull(true);
        type.createIndex(I_BLOBSTORE_BLOB_ID, OClass.INDEX_TYPE.UNIQUE_HASH_INDEX, new String[]{P_BLOBSTORE, P_BLOB_ID});
    }

    public boolean delete(ODatabaseDocumentTx db, BlobId blobId) {
        return this.delete.execute(db, new Object[]{blobId.asUniqueString()});
    }
}

