/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.internal.db.datastore;

import com.sonatype.nexus.blobstore.azure.internal.db.datastore.DeletedBlob;
import com.sonatype.nexus.blobstore.azure.internal.db.datastore.DeletedBlobDAO;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.store.ContentStoreSupport;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class DeletedBlobStore
extends ContentStoreSupport<DeletedBlobDAO> {
    @Inject
    public DeletedBlobStore(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier, "nexus", DeletedBlobDAO.class);
    }

    @Transactional
    public List<String> browse(String blobstore) {
        this.log.debug("DeletedBlobStore.browse() for deleted blob ids in blobstore {}", (Object)blobstore);
        return ((DeletedBlobDAO)this.dao()).browse(blobstore).stream().map(DeletedBlob::getBlobId).collect(Collectors.toList());
    }

    @Transactional
    public void add(String blobstore, String blobId) {
        this.log.debug("DeletedBlobStore.add() blobstore {} blobId {}", (Object)blobstore, (Object)blobId);
        ((DeletedBlobDAO)this.dao()).create(new DeletedBlob(blobstore, blobId));
    }

    @Transactional
    public boolean delete(String blobId) {
        this.log.debug("DeletedBlobStore.delete() blobId {}", (Object)blobId);
        return ((DeletedBlobDAO)this.dao()).delete(blobId);
    }
}

