/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.internal.db.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.azure.internal.DeletedBlobIndex;
import com.sonatype.nexus.blobstore.azure.internal.db.datastore.DeletedBlobStore;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobId;

@Named
@Singleton
public class DeletedBlobIndexImpl
implements DeletedBlobIndex {
    private final DeletedBlobStore deletedBlobStore;

    @Inject
    public DeletedBlobIndexImpl(DeletedBlobStore deletedBlobStore) {
        this.deletedBlobStore = (DeletedBlobStore)((Object)Preconditions.checkNotNull((Object)((Object)deletedBlobStore)));
    }

    @Override
    public void add(String blobstore, BlobId blobId) {
        this.deletedBlobStore.add(blobstore, blobId.toString());
    }

    @Override
    public void remove(BlobId blobId) {
        this.deletedBlobStore.delete(blobId.toString());
    }

    @Override
    public Stream<BlobId> browse(String blobstore) {
        return this.deletedBlobStore.browse(blobstore).stream().map(BlobId::new);
    }
}

