/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.internal.datastore;

import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.blobstore.azure.internal.AzureBlobStoreMetricsService;
import com.sonatype.nexus.blobstore.azure.internal.AzureClient;
import com.sonatype.nexus.blobstore.azure.internal.AzureConfigurationConstants;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.AccumulatingBlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsEntity;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsStore;
import org.sonatype.nexus.blobstore.metrics.DatastoreBlobStoreMetricsServiceSupport;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@Named
@Priority(value=0x7FFFFFFF)
public class DatastoreAzureBlobStoreMetricsService
extends DatastoreBlobStoreMetricsServiceSupport
implements AzureBlobStoreMetricsService {
    private static final Map<String, Long> AVAILABLE_SPACE_BY_FILE_STORE = ImmutableMap.of((Object)AzureConfigurationConstants.CONFIG_KEY, (Object)Long.MAX_VALUE);

    @Inject
    public DatastoreAzureBlobStoreMetricsService(@Named(value="${nexus.blobstore.metrics.flushInterval:-2}") @Named(value="${nexus.blobstore.metrics.flushInterval:-2}") int metricsFlushPeriodSeconds, PeriodicJobService jobService, BlobStoreMetricsStore blobStoreMetricsStore) {
        super(metricsFlushPeriodSeconds, jobService, blobStoreMetricsStore);
    }

    @Override
    public void setAzureAvailable(boolean available) {
    }

    @Override
    public void setAzureClient(AzureClient azureClient) {
    }

    public BlobStoreMetrics getMetrics() {
        BlobStoreMetricsEntity metricsEntity = this.blobStoreMetricsStore.get(this.blobStore.getBlobStoreConfiguration().getName());
        return new AccumulatingBlobStoreMetrics(metricsEntity.getBlobCount(), metricsEntity.getTotalSize(), AVAILABLE_SPACE_BY_FILE_STORE, true);
    }
}

