/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.internal.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.blobstore.azure.internal.AzureBlobStore;
import com.sonatype.nexus.blobstore.azure.internal.AzureClient;
import com.sonatype.nexus.blobstore.azure.internal.AzureConfigurationConstants;
import com.sonatype.nexus.blobstore.azure.internal.AzurePropertiesFile;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.BlobStoreMetricsPropertiesReaderSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.common.node.NodeAccess;

@Named(value="Azure")
@Singleton
public class AzureBlobstoreMetricsPropertiesReader
extends BlobStoreMetricsPropertiesReaderSupport<AzurePropertiesFile> {
    private static final Map<String, Long> AVAILABLE_SPACE_BY_FILE_STORE = ImmutableMap.of((Object)AzureConfigurationConstants.CONFIG_KEY, (Object)Long.MAX_VALUE);
    private final NodeAccess nodeAccess;
    private AzureConfig azureConfiguration;

    @Inject
    public AzureBlobstoreMetricsPropertiesReader(NodeAccess nodeAccess) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    public void initWithBlobStore(BlobStore blobStore) throws Exception {
        if (!(blobStore instanceof AzureBlobStore)) {
            throw new IllegalArgumentException("BlobStore must be of type AzureBlobStore");
        }
        AzureBlobStore azureBlobStore = (AzureBlobStore)blobStore;
        azureBlobStore.useAzureConfig(azureConfig -> {
            AzureConfig azureConfig2 = this.azureConfiguration = azureConfig;
        });
    }

    protected AzurePropertiesFile getProperties() throws Exception {
        return new AzurePropertiesFile(this.azureConfiguration.getAzureClient(), String.valueOf(this.nodeAccess.getId()) + "-" + this.metricsFilename());
    }

    protected Map<String, Long> getAvailableSpace() throws Exception {
        return AVAILABLE_SPACE_BY_FILE_STORE;
    }

    public static final class AzureConfig {
        private final AzureClient azureClient;

        public AzureConfig(AzureClient azureClient) {
            this.azureClient = (AzureClient)Preconditions.checkNotNull((Object)azureClient);
        }

        public AzureClient getAzureClient() {
            return this.azureClient;
        }
    }
}

