/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.internal;

import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.blobstore.azure.internal.AzureBlobStoreMetricsService;
import com.sonatype.nexus.blobstore.azure.internal.AzureClient;
import com.sonatype.nexus.blobstore.azure.internal.AzureConfigurationConstants;
import com.sonatype.nexus.blobstore.azure.internal.AzurePropertiesFile;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.AccumulatingBlobStoreMetrics;
import org.sonatype.nexus.blobstore.BlobStoreMetricsNotAvailableException;
import org.sonatype.nexus.blobstore.BlobStoreMetricsStoreSupport;
import org.sonatype.nexus.blobstore.api.OperationMetrics;
import org.sonatype.nexus.blobstore.api.OperationType;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@Named
public class OrientAzureBlobStoreMetricsStore
extends BlobStoreMetricsStoreSupport<AzurePropertiesFile>
implements AzureBlobStoreMetricsService {
    private static final Map<String, Long> AVAILABLE_SPACE_BY_FILE_STORE = ImmutableMap.of((Object)AzureConfigurationConstants.CONFIG_KEY, (Object)Long.MAX_VALUE);
    private boolean azureAvailable;
    private AzureClient azureClient;

    @Inject
    public OrientAzureBlobStoreMetricsStore(NodeAccess nodeAccess, PeriodicJobService jobService) {
        super(nodeAccess, jobService);
    }

    @Override
    public void setAzureAvailable(boolean available) {
        this.azureAvailable = available;
    }

    @Override
    public void setAzureClient(AzureClient azureClient) {
        this.azureClient = azureClient;
    }

    protected void doStart() throws Exception {
        if (this.azureAvailable) {
            super.doStart();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.azureClient = null;
    }

    protected AzurePropertiesFile getProperties() {
        return new AzurePropertiesFile(this.azureClient, String.valueOf(this.nodeAccess.getId()) + "-" + "metrics.properties");
    }

    protected AccumulatingBlobStoreMetrics getAccumulatingBlobStoreMetrics() {
        return new AccumulatingBlobStoreMetrics(0L, 0L, AVAILABLE_SPACE_BY_FILE_STORE, true);
    }

    protected Stream<AzurePropertiesFile> backingFiles() throws BlobStoreMetricsNotAvailableException {
        if (this.azureClient == null) {
            return Stream.empty();
        }
        this.azureClient.checkAvailability();
        return Stream.of(this.getProperties());
    }

    private static boolean metricsFileSuffix(String s) {
        return s.endsWith("metrics.properties");
    }

    public Map<OperationType, OperationMetrics> getOperationMetricsDelta() {
        return super.getOperationMetrics();
    }

    public void flush() throws IOException {
        super.flushProperties();
    }

    public void remove() {
        try {
            this.backingFiles().forEach(metricsFile -> metricsFile.remove());
        }
        catch (BlobStoreMetricsNotAvailableException e) {
            this.log.warn("unable to delete metrics files", (Throwable)e);
        }
    }
}

