/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.internal;

import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.identity.EnvironmentCredential;
import com.azure.identity.EnvironmentCredentialBuilder;
import com.azure.identity.ManagedIdentityCredential;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.sonatype.nexus.blobstore.azure.internal.AzureClient;
import com.sonatype.nexus.blobstore.azure.internal.AzureClientImpl;
import com.sonatype.nexus.blobstore.azure.internal.AzureConfigurationConstants;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;

@Named
public class AzureStorageClientFactory
extends ComponentSupport {
    private final int chunkSize;
    private final int copyTimeout;
    private final int listBlobsTimeout;
    private final int maxUploadThreads;
    private final String scheme;
    private final String server;

    @Inject
    public AzureStorageClientFactory(@Named(value="${nexus.azure.blocksize:-5242880}") @Named(value="${nexus.azure.blocksize:-5242880}") int chunkSize, @Named(value="${nexus.azure.copyTimeout_sec:-30}") @Named(value="${nexus.azure.copyTimeout_sec:-30}") int copyTimeout, @Named(value="${nexus.azure.listBlobsTimout_sec:-30}") @Named(value="${nexus.azure.listBlobsTimout_sec:-30}") int listBlobsTimeout, @Named(value="${nexus.azure.scheme:-https}") @Named(value="${nexus.azure.scheme:-https}") String scheme, @Named(value="${nexus.azure.server:-blob.core.windows.net}") @Named(value="${nexus.azure.server:-blob.core.windows.net}") String server, @Named(value="${nexus.azure.maxUploadThreads:-5}") @Named(value="${nexus.azure.maxUploadThreads:-5}") int maxUploadThreads) {
        this.chunkSize = chunkSize;
        this.copyTimeout = copyTimeout;
        this.listBlobsTimeout = listBlobsTimeout;
        this.maxUploadThreads = maxUploadThreads;
        this.scheme = scheme;
        this.server = server;
    }

    public AzureClient create(BlobStoreConfiguration blobStoreConfiguration) throws Exception {
        String accountName = (String)blobStoreConfiguration.attributes(AzureConfigurationConstants.CONFIG_KEY).get("accountName", String.class);
        String accountKey = (String)blobStoreConfiguration.attributes(AzureConfigurationConstants.CONFIG_KEY).get("accountKey", String.class);
        String containerName = (String)blobStoreConfiguration.attributes(AzureConfigurationConstants.CONFIG_KEY).get("containerName", String.class);
        String authenticationMethod = (String)blobStoreConfiguration.attributes(AzureConfigurationConstants.CONFIG_KEY).get("authenticationMethod", String.class);
        String overrideScheme = this.scheme;
        String overrideServer = this.server;
        String endpoint = (String)blobStoreConfiguration.attributes(AzureConfigurationConstants.CONFIG_KEY).get("endpoint", String.class);
        if (endpoint != null) {
            URI endpointUri = URI.create(endpoint);
            overrideScheme = endpointUri.getScheme();
            overrideServer = String.valueOf(endpointUri.getHost()) + AzureStorageClientFactory.portSuffix(endpointUri);
        }
        return this.create(accountName, accountKey, containerName, authenticationMethod, overrideScheme, overrideServer);
    }

    private static String portSuffix(URI uri) {
        if (uri.getPort() == -1) {
            return "";
        }
        return ":" + uri.getPort();
    }

    public AzureClient create(String accountName, String accountKey, String containerName, String authenticationMethod) {
        return this.create(accountName, accountKey, containerName, authenticationMethod, this.scheme, this.server);
    }

    private AzureClient create(String accountName, String accountKey, String containerName, String authenticationMethod, String schemeOverride, String serverOverride) {
        String host;
        ManagedIdentityCredential tokenCredential = null;
        StorageSharedKeyCredential sharedKeyCredential = null;
        EnvironmentCredential environmentCredential = null;
        if ("MANAGEDIDENTITY".equals(authenticationMethod)) {
            tokenCredential = new ManagedIdentityCredentialBuilder().build();
        } else if ("ACCOUNTKEY".equals(authenticationMethod)) {
            sharedKeyCredential = new StorageSharedKeyCredential(accountName, accountKey);
        } else if ("ENVIRONMENTVARIABLE".equals(authenticationMethod)) {
            environmentCredential = new EnvironmentCredentialBuilder().build();
        }
        try {
            host = new URL("http://" + serverOverride).getPort() == -1 ? String.format(Locale.ROOT, "%s.%s", accountName, serverOverride) : serverOverride;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        BlobUrlParts parts = new BlobUrlParts();
        parts.setScheme(schemeOverride);
        parts.setHost(host);
        parts.setAccountName(accountName);
        String endpoint = parts.toUrl().toString();
        BlobServiceClientBuilder builder = new BlobServiceClientBuilder().endpoint(endpoint).httpClient(new NettyAsyncHttpClientBuilder().build());
        if (tokenCredential != null) {
            builder.credential(tokenCredential);
        } else if (sharedKeyCredential != null) {
            builder.credential(sharedKeyCredential);
        } else if (environmentCredential != null) {
            builder.credential(environmentCredential);
        }
        return new AzureClientImpl(builder.buildClient(), containerName, this.chunkSize, this.copyTimeout, this.listBlobsTimeout, this.maxUploadThreads);
    }
}

