/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.azure.internal.AzureClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.property.ImplicitSourcePropertiesFile;

public class AzurePropertiesFile
extends ImplicitSourcePropertiesFile {
    private static final Logger log = LoggerFactory.getLogger(AzurePropertiesFile.class);
    private AzureClient azureClient;
    private final String key;

    public AzurePropertiesFile(AzureClient azureClient, String key) {
        this.azureClient = (AzureClient)Preconditions.checkNotNull((Object)azureClient);
        this.key = (String)Preconditions.checkNotNull((Object)key);
    }

    public void load() throws IOException {
        log.debug("Loading properties: {}", (Object)this.key);
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream is = this.azureClient.get(this.key);){
            this.load(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void store() throws IOException {
        log.debug("Storing properties: {}", (Object)this.key);
        ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
        this.store(bufferStream, null);
        this.azureClient.create(this.key, new ByteArrayInputStream(bufferStream.toByteArray()));
    }

    public boolean exists() {
        return this.azureClient.exists(this.key);
    }

    public void remove() {
        this.azureClient.delete(this.key);
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "key=" + this.key + '}';
    }
}

