/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.internal;

import com.azure.storage.blob.models.BlobStorageException;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.blobstore.api.BlobStoreConnectionException;

public class AzureExceptionDetector {
    private static final Messages messages = (Messages)I18N.create(Messages.class);

    public static Exception mapConnectionConfigurationException(Exception e, String authenticationMethod) {
        String message;
        if (e instanceof BlobStorageException && "MANAGEDIDENTITY".equals(authenticationMethod) && (message = e.getMessage()) != null && message.contains("AuthorizationPermissionMismatch")) {
            return new BlobStoreConnectionException(messages.managedIdentityPermissionError());
        }
        if (e instanceof BlobStorageException && "ACCOUNTKEY".equals(authenticationMethod) && (message = e.getMessage()) != null && message.contains("403")) {
            return new BlobStoreConnectionException(messages.unauthorizedError());
        }
        return e;
    }

    public static RuntimeException mapConnectionConfigurationException(RuntimeException e, String authenticationMethod) {
        return (RuntimeException)AzureExceptionDetector.mapConnectionConfigurationException((Exception)e, authenticationMethod);
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="VM does not have the correct permissions to access the Storage account. Grant the roles 'Storage Account Contributor' and 'Storage Blob Data Contributor' to the Storage Account for your VM")
        public String managedIdentityPermissionError();

        @MessageBundle.DefaultMessage(value="Invalid Azure blobstore authentication provided")
        public String unauthorizedError();
    }
}

