/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.internal;

import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.SyncPoller;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobCopyInfo;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.options.BlobBeginCopyOptions;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.azure.internal.AzureClient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.BlobStoreMetricsNotAvailableException;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

public class AzureClientImpl
extends ComponentSupport
implements AzureClient {
    private final BlobServiceClient serviceClient;
    private final int chunkSize;
    private final String containerName;
    private final int copyTimeout;
    private final int listBlobsTimeout;
    private ExecutorService executor;

    public AzureClientImpl(BlobServiceClient serviceClient, String containerName, int chunkSize, int copyTimeout, int listBlobsTimeout, int maxUploadThreads) {
        this.serviceClient = (BlobServiceClient)Preconditions.checkNotNull((Object)serviceClient);
        this.containerName = (String)Preconditions.checkNotNull((Object)containerName);
        Preconditions.checkArgument((chunkSize > 0 ? 1 : 0) != 0, (Object)"Chunk size must be > 0");
        this.chunkSize = chunkSize;
        Preconditions.checkArgument((copyTimeout > 0 ? 1 : 0) != 0, (Object)"Copy timout must be > 0");
        this.copyTimeout = copyTimeout;
        Preconditions.checkArgument((listBlobsTimeout > 0 ? 1 : 0) != 0, (Object)"List blob timeout must be > 0");
        this.listBlobsTimeout = listBlobsTimeout;
        this.executor = NexusExecutorService.forCurrentSubject((ExecutorService)Executors.newFixedThreadPool(maxUploadThreads, (ThreadFactory)new NexusThreadFactory("azure-blobstore-upload-pool", "azure-blob-upload-client")));
    }

    @Override
    public void checkAvailability() throws BlobStoreMetricsNotAvailableException {
        try {
            if (!this.containerExists()) {
                throw new BlobStoreException("blob container doesn't exist", null);
            }
        }
        catch (Exception e) {
            this.log.warn("Azure connection is unavailable", (Throwable)(this.log.isDebugEnabled() ? e : null));
            throw new BlobStoreMetricsNotAvailableException((Throwable)e);
        }
    }

    @Override
    public void create(String path, InputStream data) {
        this.log.debug("Creating blob {}", (Object)path);
        try {
            int bytesRead;
            ArrayList<Future<Void>> futureExecutorServiceList = new ArrayList<Future<Void>>();
            BlockBlobClient blockBlobClient = this.getCloudBlobContainer().getBlobClient(path).getBlockBlobClient();
            ArrayList<String> blockList = new ArrayList<String>();
            int totalRead = 0;
            byte[] buffer = new byte[this.chunkSize];
            while ((bytesRead = data.read(buffer, totalRead, buffer.length - totalRead)) != -1) {
                if ((totalRead += bytesRead) != buffer.length) continue;
                futureExecutorServiceList.add(this.executor.submit(this.stageTask(blockBlobClient, blockList, totalRead, buffer)));
                totalRead = 0;
            }
            if (totalRead > 0) {
                futureExecutorServiceList.add(this.executor.submit(this.stageTask(blockBlobClient, blockList, totalRead, buffer)));
            }
            for (Future future : futureExecutorServiceList) {
                future.get();
            }
            this.log.debug("Blocks committed for {} -> {}", (Object)path, (Object)blockList.size());
            blockBlobClient.commitBlockList(blockList, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.log.error(String.format("Error staging file chunk", new Object[0]));
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            this.log.error(String.format("Error staging file chunk", new Object[0]));
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private Callable<Void> stageTask(BlockBlobClient blockBlobClient, List<String> blockList, int totalRead, byte[] buffer) {
        String base64BlockId = AzureClientImpl.createBase64BlockId();
        blockList.add(base64BlockId);
        int totalReadCallable = totalRead;
        byte[] bufferCallable = Arrays.copyOf(buffer, buffer.length);
        return () -> this.uploadBlock(blockBlobClient, totalReadCallable, bufferCallable, base64BlockId);
    }

    private Void uploadBlock(BlockBlobClient blob, int length, byte[] data, String base64BlockId) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data, 0, length);
        blob.stageBlock(base64BlockId, byteArrayInputStream, length);
        return null;
    }

    private static String createBase64BlockId() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return Base64.getEncoder().encodeToString(bb.array());
    }

    @Override
    public InputStream get(String path) {
        this.log.debug("Getting blob {}", (Object)path);
        return this.getCloudBlobContainer().getBlobClient(path).openInputStream();
    }

    @Override
    public boolean exists(String path) {
        boolean exists = this.getCloudBlobContainer().getBlobClient(path).exists();
        this.log.debug("{} exists? -> {}", (Object)path, (Object)exists);
        return exists;
    }

    @Override
    public void delete(String path) {
        this.log.debug("Deleting blob {}", (Object)path);
        this.getCloudBlobContainer().getBlobClient(path).delete();
    }

    @Override
    public void copy(String sourcePath, String destination) {
        this.log.debug("Copying blob {} => {}", (Object)sourcePath, (Object)destination);
        BlobClient srcClient = this.getCloudBlobContainer().getBlobClient(sourcePath);
        BlobClient destClient = this.getCloudBlobContainer().getBlobClient(destination);
        SyncPoller<BlobCopyInfo, Void> poller = destClient.beginCopy(new BlobBeginCopyOptions(srcClient.getBlobUrl()));
        LongRunningOperationStatus status = poller.waitForCompletion(Duration.ofSeconds(this.copyTimeout)).getStatus();
        if (!status.isComplete()) {
            this.log.warn("Copying blob {} is taking a while and will affect performance", (Object)srcClient.getBlobUrl());
        }
    }

    @Override
    public Stream<String> listFiles(String contentPrefix) {
        ListBlobsOptions options = new ListBlobsOptions();
        options.setPrefix(contentPrefix);
        return this.getCloudBlobContainer().listBlobs(options, Duration.ofSeconds(this.listBlobsTimeout)).stream().map(BlobItem::getName);
    }

    @Override
    public Stream<String> listFiles(String contentPrefix, Predicate<String> blobSuffixFilter) {
        return this.listFiles(contentPrefix).filter(blobSuffixFilter);
    }

    @Override
    public void createContainer() {
        if (!this.getCloudBlobContainer().exists()) {
            this.getCloudBlobContainer().create();
        }
    }

    @Override
    public void deleteContainer() {
        this.getCloudBlobContainer().delete();
    }

    @Override
    public boolean containerExists() {
        return this.getCloudBlobContainer().exists();
    }

    private BlobContainerClient getCloudBlobContainer() {
        return this.serviceClient.getBlobContainerClient(this.getContainerName());
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    public void canWriteContentToContainer() throws Exception {
        String fileName = ".placeholder";
        this.create(fileName, new ByteArrayInputStream(new byte[0]));
        this.delete(fileName);
    }
}

