/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.internal;

import com.sonatype.nexus.blobstore.azure.AzureBlobStoreFeature;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.feature.LicenseFeatureVerifier;
import org.sonatype.nexus.blobstore.BlobStoreDescriptorSupport;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.formfields.FormField;

@AvailabilityVersion(from="1.0")
@Named(value="Azure Cloud Storage")
public class AzureBlobStoreDescriptor
extends BlobStoreDescriptorSupport {
    @Inject
    private LicenseFeatureVerifier licenseFeatureVerifier;
    @Inject
    private NodeAccess nodeAccess;
    @Inject
    @Named(value="azureBlobStore")
    private AzureBlobStoreFeature azureBlobStoreFeature;
    @Inject
    @Named(value="${nexus.datastore.clustered.enabled:-false}")
    private boolean datastoreClustered;
    private static final Messages messages = (Messages)I18N.create(Messages.class);

    @Inject
    public AzureBlobStoreDescriptor(BlobStoreQuotaService quotaService) {
        super(quotaService);
    }

    public String getId() {
        return "azure";
    }

    public String customFormName() {
        return "nx-blobstore-settings-azure";
    }

    public String getName() {
        return messages.name();
    }

    public final List<FormField> getFormFields() {
        return Collections.emptyList();
    }

    public boolean isConnectionTestable() {
        return true;
    }

    public boolean isEnabled() {
        if (!this.licenseFeatureVerifier.verify((Feature)this.azureBlobStoreFeature) || this.nodeAccess.isClustered() && !this.datastoreClustered) {
            return false;
        }
        return super.isEnabled();
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Azure Cloud Storage")
        public String name();
    }
}

