/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.blobstore.azure.AzureBlobStoreFeature;
import com.sonatype.nexus.blobstore.azure.internal.AzureAttributesLocation;
import com.sonatype.nexus.blobstore.azure.internal.AzureBlobAttributes;
import com.sonatype.nexus.blobstore.azure.internal.AzureBlobStoreMetricsService;
import com.sonatype.nexus.blobstore.azure.internal.AzureClient;
import com.sonatype.nexus.blobstore.azure.internal.AzureConfigurationConstants;
import com.sonatype.nexus.blobstore.azure.internal.AzureExceptionDetector;
import com.sonatype.nexus.blobstore.azure.internal.AzurePropertiesFile;
import com.sonatype.nexus.blobstore.azure.internal.AzureStorageClientFactory;
import com.sonatype.nexus.blobstore.azure.internal.BlobMetricsConsumer;
import com.sonatype.nexus.blobstore.azure.internal.DeletedBlobIndex;
import com.sonatype.nexus.blobstore.azure.internal.datastore.AzureBlobstoreMetricsPropertiesReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.feature.LicenseFeatureVerifier;
import org.sonatype.nexus.blobstore.AttributesLocation;
import org.sonatype.nexus.blobstore.BlobIdLocationResolver;
import org.sonatype.nexus.blobstore.BlobStoreMetricsNotAvailableException;
import org.sonatype.nexus.blobstore.BlobSupport;
import org.sonatype.nexus.blobstore.CloudBlobStoreSupport;
import org.sonatype.nexus.blobstore.MetricsInputStream;
import org.sonatype.nexus.blobstore.StreamMetrics;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobMetrics;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.BlobStoreUsageChecker;
import org.sonatype.nexus.blobstore.api.OperationMetrics;
import org.sonatype.nexus.blobstore.api.OperationType;
import org.sonatype.nexus.blobstore.api.RawObjectAccess;
import org.sonatype.nexus.blobstore.api.UnimplementedRawObjectAccess;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsService;
import org.sonatype.nexus.blobstore.metrics.MonitoringBlobStoreMetrics;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaUsageChecker;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.thread.TcclBlock;

@Named(value="Azure Cloud Storage")
public class AzureBlobStore
extends CloudBlobStoreSupport<AttributesLocation> {
    public static final String METADATA_FILENAME = "metadata.properties";
    static final String CONTENT_PREFIX = "content";
    public static final String DIRECT_PATH_PREFIX = "content/directpath";
    public static final String TYPE_KEY = "type";
    public static final String TYPE_V1 = "azure/1";
    public static final String UNABLE_TO_INIT_BS_MESSAGE = "Unable to initialize blob store container. Please ensure that you have correct configuration, and it is supported by your version of Sonatype Nexus Repository";
    public static final String TYPE = "Azure Cloud Storage";
    private AzureStorageClientFactory azureStorageClientFactory;
    private final BlobIdLocationResolver blobIdLocationResolver;
    @VisibleForTesting
    public final AzureBlobStoreMetricsService metricsService;
    private final DryRunPrefix dryRunPrefix;
    private AzureClient azureClient;
    private boolean isAzureAvailable;
    private LoadingCache<BlobId, AzureBlob> liveBlobs;
    private DeletedBlobIndex deletedBlobIndex;
    private final LicenseFeatureVerifier licenseFeatureVerifier;
    private final AzureBlobStoreFeature azureBlobStoreFeature;
    private final NodeAccess nodeAccess;
    private final BlobStoreQuotaUsageChecker blobStoreQuotaUsageChecker;
    private final boolean datastoreClustered;

    @Inject
    public AzureBlobStore(AzureStorageClientFactory azureStorageClientFactory, BlobIdLocationResolver blobIdLocationResolver, AzureBlobStoreMetricsService metricsStore, DryRunPrefix dryRunPrefix, DeletedBlobIndex deletedBlobIndex, LicenseFeatureVerifier licenseFeatureVerifier, AzureBlobStoreFeature azureBlobStoreFeature, NodeAccess nodeAccess, BlobStoreQuotaUsageChecker blobStoreQuotaUsageChecker, @Named(value="${nexus.datastore.clustered.enabled:-false}") @Named(value="${nexus.datastore.clustered.enabled:-false}") boolean datastoreClustered) {
        super(blobIdLocationResolver, dryRunPrefix);
        this.azureStorageClientFactory = (AzureStorageClientFactory)((Object)Preconditions.checkNotNull((Object)((Object)azureStorageClientFactory)));
        this.blobIdLocationResolver = (BlobIdLocationResolver)Preconditions.checkNotNull((Object)blobIdLocationResolver);
        this.metricsService = metricsStore;
        this.dryRunPrefix = dryRunPrefix;
        this.deletedBlobIndex = (DeletedBlobIndex)Preconditions.checkNotNull((Object)deletedBlobIndex);
        this.licenseFeatureVerifier = (LicenseFeatureVerifier)Preconditions.checkNotNull((Object)licenseFeatureVerifier);
        this.azureBlobStoreFeature = (AzureBlobStoreFeature)((Object)Preconditions.checkNotNull((Object)((Object)azureBlobStoreFeature)));
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.blobStoreQuotaUsageChecker = (BlobStoreQuotaUsageChecker)Preconditions.checkNotNull((Object)blobStoreQuotaUsageChecker);
        this.datastoreClustered = datastoreClustered;
    }

    protected void doStart() throws Exception {
        this.log.debug("Starting");
        this.checkAvailability();
        if (this.isAzureAvailable) {
            AzurePropertiesFile metadata = new AzurePropertiesFile(this.azureClient, METADATA_FILENAME);
            if (metadata.exists()) {
                metadata.load();
                String type = metadata.getProperty(TYPE_KEY);
                Preconditions.checkState((boolean)TYPE_V1.equals(type), (String)"Unsupported blob store type/version: %s in %s", (Object)type, (Object)((Object)metadata));
            } else {
                metadata.setProperty(TYPE_KEY, TYPE_V1);
                metadata.store();
            }
            this.liveBlobs = CacheBuilder.newBuilder().weakValues().build(CacheLoader.from(arg_0 -> AzureBlob.new(this, arg_0)));
            this.blobStoreQuotaUsageChecker.setBlobStore((BlobStore)this);
            this.blobStoreQuotaUsageChecker.start();
        }
        this.metricsService.setAzureClient(this.azureClient);
        this.metricsService.setAzureAvailable(this.isAzureAvailable);
        this.metricsService.setBlobStore((BlobStore)this);
        this.metricsService.start();
    }

    private void checkAvailability() {
        try {
            this.azureClient.checkAvailability();
            this.isAzureAvailable = true;
        }
        catch (BlobStoreMetricsNotAvailableException e) {
            this.log.error("azure not available", (Throwable)e);
            this.isAzureAvailable = false;
        }
    }

    protected void doStop() throws Exception {
        this.liveBlobs = null;
        this.metricsService.stop();
        this.blobStoreQuotaUsageChecker.stop();
    }

    @Guarded(by={"STARTED"})
    public boolean isAzureAvailable() {
        return this.isAzureAvailable;
    }

    @Guarded(by={"STARTED"})
    @MonitoringBlobStoreMetrics(operationType=OperationType.UPLOAD)
    public Blob create(Path path, Map<String, String> map, long size, HashCode hash) {
        throw new BlobStoreException("hard links not supported", null);
    }

    @MonitoringBlobStoreMetrics(operationType=OperationType.UPLOAD)
    protected Blob doCreate(InputStream blobData, Map<String, String> headers, @Nullable BlobId blobId) {
        this.checkIfAddingAssetsIsAllowed();
        return this.create(headers, destination -> {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream data = blobData;){
                MetricsInputStream input = new MetricsInputStream(data);
                this.azureClient.create(destination, (InputStream)input);
                return input.getMetrics();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }, blobId);
    }

    public void useAzureConfig(Consumer<AzureBlobstoreMetricsPropertiesReader.AzureConfig> configConsumer) {
        configConsumer.accept(new AzureBlobstoreMetricsPropertiesReader.AzureConfig(this.azureClient));
    }

    private void checkIfAddingAssetsIsAllowed() {
        if (!this.licenseFeatureVerifier.verify((Feature)this.azureBlobStoreFeature)) {
            throw new RuntimeException("Pro license required adding assets to an Azure blob store.");
        }
        if (this.nodeAccess.isClustered() && !this.datastoreClustered) {
            throw new RuntimeException("Azure blob stores not supported in HA clustered mode.");
        }
    }

    private Blob create(Map<String, String> headers, BlobMetricsConsumer blobMetricsConsumer, @Nullable BlobId assignedBlobId) {
        BlobId blobId = this.getBlobId(headers, assignedBlobId);
        String blobPath = this.contentPath(blobId);
        String attributePath = this.attributePath(blobId);
        boolean isDirectPath = Boolean.parseBoolean(headers.getOrDefault("BlobStore.direct-path", "false"));
        Long existingSize = null;
        if (isDirectPath) {
            AzureBlobAttributes blobAttributes = new AzureBlobAttributes(this.azureClient, attributePath);
            if (this.exists(blobId)) {
                existingSize = this.getContentSizeForDeletion(blobAttributes);
            }
        }
        AzureBlob blob = (AzureBlob)((Object)this.liveBlobs.getUnchecked((Object)blobId));
        Lock lock = blob.lock();
        try {
            this.log.debug("Writing blob {} to {}", (Object)blobId, (Object)blobPath);
            StreamMetrics streamMetrics = blobMetricsConsumer.apply(blobPath);
            BlobMetrics metrics = new BlobMetrics(new DateTime(), streamMetrics.getSha1(), streamMetrics.getSize());
            blob.refresh(headers, metrics);
            AzureBlobAttributes blobAttributes = new AzureBlobAttributes(this.azureClient, attributePath, headers, metrics);
            blobAttributes.store();
            if (isDirectPath && existingSize != null) {
                this.metricsService.recordDeletion(existingSize);
            }
            this.metricsService.recordAddition(blobAttributes.getMetrics().getContentSize());
            AzureBlob azureBlob = blob;
            return azureBlob;
        }
        catch (IOException e) {
            this.azureClient.delete(attributePath);
            this.azureClient.delete(blobPath);
            throw new BlobStoreException((Throwable)e, blobId);
        }
        finally {
            lock.unlock();
        }
    }

    @Nullable
    private Long getContentSizeForDeletion(AzureBlobAttributes blobAttributes) {
        try {
            blobAttributes.load();
            return blobAttributes.getMetrics() != null ? Long.valueOf(blobAttributes.getMetrics().getContentSize()) : null;
        }
        catch (Exception e) {
            this.log.warn("Unable to load attributes {}, delete will not be added to metrics.", (Object)blobAttributes, (Object)e);
            return null;
        }
    }

    @Guarded(by={"STARTED"})
    public Blob copy(BlobId blobId, Map<String, String> headers) {
        Blob sourceBlob = (Blob)Preconditions.checkNotNull((Object)this.get(blobId));
        String sourcePath = this.contentPath(sourceBlob.getId());
        return this.create(headers, destination -> {
            this.azureClient.copy(sourcePath, destination);
            BlobMetrics metrics = sourceBlob.getMetrics();
            return new StreamMetrics(metrics.getContentSize(), metrics.getSha1Hash());
        }, null);
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public Blob get(BlobId blobId) {
        return this.get(blobId, false);
    }

    @Nullable
    @MonitoringBlobStoreMetrics(operationType=OperationType.DOWNLOAD)
    public Blob get(BlobId blobId, boolean includeDeleted) {
        AzureBlob blob;
        block10: {
            Preconditions.checkNotNull((Object)blobId);
            blob = (AzureBlob)((Object)this.liveBlobs.getUnchecked((Object)blobId));
            if (blob.isStale()) {
                Lock lock = blob.lock();
                try {
                    if (!blob.isStale()) break block10;
                    AzureBlobAttributes blobAttributes = new AzureBlobAttributes(this.azureClient, this.attributePath(blobId));
                    boolean loaded = blobAttributes.load();
                    if (!loaded) {
                        this.log.warn("Attempt to access non-existent blob {} ({})", (Object)blobId, (Object)blobAttributes);
                        return null;
                    }
                    if (blobAttributes.isDeleted() && !includeDeleted) {
                        this.log.debug("Attempt to access soft-deleted blob {} ({})", (Object)blobId, (Object)blobAttributes);
                        return null;
                    }
                    try {
                        blob.refresh(blobAttributes.getHeaders(), blobAttributes.getMetrics());
                    }
                    catch (IOException e) {
                        throw new BlobStoreException((Throwable)e, blobId);
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
        this.log.debug("Accessing blob {}", (Object)blobId);
        return blob;
    }

    protected boolean doDelete(BlobId blobId, String reason) {
        AzureBlob blob = (AzureBlob)((Object)this.liveBlobs.getUnchecked((Object)blobId));
        Lock lock = blob.lock();
        try {
            this.log.debug("Soft deleting blob {}", (Object)blobId);
            AzureBlobAttributes blobAttributes = new AzureBlobAttributes(this.azureClient, this.attributePath(blobId));
            boolean loaded = blobAttributes.load();
            if (!loaded) {
                this.log.warn("Attempt to mark-for-delete non-existent blob {}", (Object)blobId);
                return false;
            }
            if (blobAttributes.isDeleted()) {
                this.log.debug("Attempt to delete already-deleted blob {}", (Object)blobId);
                return false;
            }
            blobAttributes.setDeleted(true);
            blobAttributes.setDeletedReason(reason);
            blobAttributes.store();
            this.deletedBlobIndex.add(this.blobStoreConfiguration.getName(), blobId);
            blob.markStale();
            return true;
        }
        catch (Exception e) {
            throw new BlobStoreException((Throwable)e, blobId);
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean doDeleteHard(BlobId blobId) {
        try {
            this.log.debug("Hard deleting blob {}", (Object)blobId);
            String attributePath = this.attributePath(blobId);
            AzureBlobAttributes blobAttributes = new AzureBlobAttributes(this.azureClient, attributePath);
            Long contentSize = this.getContentSizeForDeletion(blobAttributes);
            String blobPath = this.contentPath(blobId);
            boolean pathExists = this.azureClient.exists(blobPath);
            boolean attributePathExists = this.azureClient.exists(attributePath);
            if (contentSize != null) {
                this.metricsService.recordDeletion(contentSize);
            }
            if (pathExists) {
                this.azureClient.delete(blobPath);
            } else {
                this.log.warn("Blob path specified not found: {}", (Object)blobId);
            }
            if (attributePathExists) {
                this.azureClient.delete(attributePath);
            } else {
                this.log.warn("Attribute path specified not found: {}", (Object)blobId);
            }
            this.deletedBlobIndex.remove(blobId);
            boolean bl = pathExists;
            return bl;
        }
        catch (Exception e) {
            throw new BlobStoreException((Throwable)e, blobId);
        }
        finally {
            this.liveBlobs.invalidate((Object)blobId);
        }
    }

    @Guarded(by={"STARTED"})
    public BlobStoreMetricsService getMetricsService() {
        return this.metricsService;
    }

    @Guarded(by={"STARTED"})
    public BlobStoreMetrics getMetrics() {
        return this.metricsService.getMetrics();
    }

    public Map<OperationType, OperationMetrics> getOperationMetricsByType() {
        return this.metricsService.getOperationMetrics();
    }

    public Map<OperationType, OperationMetrics> getOperationMetricsDelta() {
        return this.metricsService.getOperationMetricsDelta();
    }

    public void clearOperationMetrics() {
        this.metricsService.clearOperationMetrics();
    }

    protected void doCompact(@Nullable BlobStoreUsageChecker inUseChecker) {
        this.deletedBlobIndex.browse(this.blobStoreConfiguration.getName()).forEach(arg_0 -> ((AzureBlobStore)this).deleteHard(arg_0));
    }

    public BlobStoreConfiguration getBlobStoreConfiguration() {
        return this.blobStoreConfiguration;
    }

    protected BlobAttributes getBlobAttributes(AttributesLocation attributesFilePath) throws IOException {
        AzureBlobAttributes azureBlobAttributes = new AzureBlobAttributes(this.azureClient, attributesFilePath.getFullPath());
        azureBlobAttributes.load();
        return azureBlobAttributes;
    }

    protected void doInit(BlobStoreConfiguration blobStoreConfiguration) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (TcclBlock tccl = TcclBlock.begin(((Object)((Object)this)).getClass());){
                this.azureClient = this.azureStorageClientFactory.create(blobStoreConfiguration);
                if (!this.azureClient.containerExists()) {
                    this.azureClient.createContainer();
                }
                this.azureClient.canWriteContentToContainer();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            String authenticationMethod = (String)blobStoreConfiguration.attributes(AzureConfigurationConstants.CONFIG_KEY).get("authenticationMethod");
            if (this.log.isDebugEnabled()) {
                throw new BlobStoreException(UNABLE_TO_INIT_BS_MESSAGE, (Throwable)AzureExceptionDetector.mapConnectionConfigurationException(e, authenticationMethod), null);
            }
            throw new BlobStoreException(UNABLE_TO_INIT_BS_MESSAGE, null);
        }
    }

    @Guarded(by={"NEW", "STOPPED", "FAILED", "SHUTDOWN"})
    public void remove() {
        boolean contentEmpty;
        this.metricsService.remove();
        boolean bl = contentEmpty = !this.azureClient.listFiles("content/").findAny().isPresent();
        if (contentEmpty) {
            new AzurePropertiesFile(this.azureClient, METADATA_FILENAME).remove();
            this.azureClient.deleteContainer();
        }
    }

    @Guarded(by={"STARTED"})
    public Stream<BlobId> getBlobIdStream() {
        return this.nonTempBlobPropertiesFileStream(this.azureClient.listFiles(CONTENT_PREFIX, this::blobItemPredicate)).map(arg_0 -> ((AzureBlobStore)this).getBlobIdFromAttributeFilePath(arg_0)).map(BlobId::new);
    }

    public Stream<BlobId> getBlobIdUpdatedSinceStream(int sinceDays) {
        return this.getBlobIdStream();
    }

    @Guarded(by={"STARTED"})
    public Stream<BlobId> getDirectPathBlobIdStream(String prefix) {
        return this.azureClient.listFiles(String.format("%s/%s", DIRECT_PATH_PREFIX, prefix), this::blobItemPredicate).map(this::attributePathToDirectPathBlobId);
    }

    private Stream<AzureAttributesLocation> nonTempBlobPropertiesFileStream(Stream<String> files) {
        return files.map(AzureAttributesLocation::new).filter(this::isNonTempBlob);
    }

    private boolean isNonTempBlob(AzureAttributesLocation location) {
        try {
            BlobAttributes attributes = this.getBlobAttributes(location);
            if (attributes != null) {
                return !attributes.getHeaders().containsKey("BlobStore.temporary-blob");
            }
        }
        catch (IOException iOException) {
            this.log.error(String.format("missing attributes file for location '%s' ", location));
        }
        return true;
    }

    private boolean blobItemPredicate(String name) {
        return name.endsWith(".properties");
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public BlobAttributes getBlobAttributes(BlobId blobId) {
        try {
            AzureBlobAttributes blobAttributes = new AzureBlobAttributes(this.azureClient, this.attributePath(blobId));
            return blobAttributes.load() ? blobAttributes : null;
        }
        catch (IOException e) {
            this.log.error("Unable to load AzureBlobAttributes for blob id: {}", (Object)blobId, (Object)e);
            return null;
        }
    }

    @Guarded(by={"STARTED"})
    public void setBlobAttributes(BlobId blobId, BlobAttributes blobAttributes) {
        AzureBlobAttributes existing = (AzureBlobAttributes)this.getBlobAttributes(blobId);
        if (existing != null) {
            try {
                existing.updateFrom(blobAttributes);
                existing.store();
            }
            catch (IOException e) {
                this.log.error("Unable to set AzureBlobAttributes for blob id: {}", (Object)blobId, (Object)e);
            }
        }
    }

    @Guarded(by={"STARTED"})
    public boolean exists(BlobId blobId) {
        Preconditions.checkNotNull((Object)blobId);
        AzureBlobAttributes blobAttributes = new AzureBlobAttributes(this.azureClient, this.attributePath(blobId));
        try {
            return blobAttributes.load();
        }
        catch (IOException ioe) {
            this.log.debug("Unable to load attributes {} during existence check, exception: {}", (Object)blobAttributes, (Object)ioe);
            return false;
        }
    }

    @Guarded(by={"STARTED"})
    public boolean undelete(@Nullable BlobStoreUsageChecker blobStoreUsageChecker, BlobId blobId, BlobAttributes attributes, boolean isDryRun) {
        Preconditions.checkNotNull((Object)attributes);
        String logPrefix = isDryRun ? this.dryRunPrefix.get() : "";
        Optional<String> blobName = Optional.of(attributes).map(BlobAttributes::getProperties).map(p -> p.getProperty("@BlobStore.blob-name"));
        if (!blobName.isPresent()) {
            this.log.error("Property not present: {}, for blob id: {}, at path: {}", new Object[]{"@BlobStore.blob-name", blobId, this.attributePath(blobId)});
            return false;
        }
        if (attributes.isDeleted() && blobStoreUsageChecker != null && blobStoreUsageChecker.test((BlobStore)this, blobId, blobName.get())) {
            String deletedReason = attributes.getDeletedReason();
            if (!isDryRun) {
                attributes.setDeleted(false);
                attributes.setDeletedReason(null);
                try {
                    attributes.store();
                }
                catch (IOException e) {
                    this.log.error("Error while un-deleting blob id: {}, deleted reason: {}, blob store: {}, blob name: {}", new Object[]{blobId, deletedReason, this.blobStoreConfiguration.getName(), blobName.get(), e});
                }
            }
            this.log.warn("{}Soft-deleted blob still in use, un-deleting blob id: {}, deleted reason: {}, blob store: {}, blob name: {}", new Object[]{logPrefix, blobId, deletedReason, this.blobStoreConfiguration.getName(), blobName.get()});
            return true;
        }
        return false;
    }

    public boolean isStorageAvailable() {
        try {
            return this.azureClient.containerExists();
        }
        catch (Exception e) {
            this.log.warn("Azure container '{}' is not writable.", (Object)this.azureClient.getContainerName(), (Object)e);
            return false;
        }
    }

    public void validateCanCreateAndUpdate() {
        if (!this.licenseFeatureVerifier.verify((Feature)this.azureBlobStoreFeature)) {
            this.log.warn("Azure Blob Stores are a Pro only feature.");
            throw new RuntimeException("Pro license required for creating Azure blob stores.");
        }
        if (this.nodeAccess.isClustered() && !this.datastoreClustered) {
            throw new RuntimeException("Azure blob stores not supported in HA clustered mode.");
        }
    }

    protected String attributePathString(BlobId blobId) {
        return this.attributePath(blobId);
    }

    @VisibleForTesting
    String contentPath(BlobId id) {
        return String.valueOf(this.getLocation(id)) + ".bytes";
    }

    @VisibleForTesting
    protected String attributePath(BlobId id) {
        return String.valueOf(this.getLocation(id)) + ".properties";
    }

    @VisibleForTesting
    String getLocation(BlobId id) {
        return "content/" + this.blobIdLocationResolver.getLocation(id);
    }

    private BlobId attributePathToDirectPathBlobId(String key) {
        Preconditions.checkArgument((boolean)key.startsWith("content/directpath/"), (String)"Not direct path blob path: %s", (Object)key);
        Preconditions.checkArgument((boolean)key.endsWith(".properties"), (String)"Not blob attribute path: %s", (Object)key);
        String blobName = key.substring(0, key.length() - ".properties".length()).substring(DIRECT_PATH_PREFIX.length() + 1);
        ImmutableMap headers = ImmutableMap.of((Object)"BlobStore.blob-name", (Object)blobName, (Object)"BlobStore.direct-path", (Object)"true");
        return this.blobIdLocationResolver.fromHeaders((Map)headers);
    }

    public RawObjectAccess getRawObjectAccess() {
        return new UnimplementedRawObjectAccess();
    }

    @VisibleForTesting
    public void flushMetrics() throws IOException {
        this.metricsService.flush();
    }

    @Guarded(by={"STARTED"})
    public Blob writeBlobProperties(BlobId blobId, Map<String, String> headers) {
        AzureBlob blob = (AzureBlob)((Object)Preconditions.checkNotNull((Object)this.get(blobId)));
        String blobPath = this.contentPath(blob.getId());
        String attributePath = this.attributePath(blobId);
        BlobMetrics metrics = blob.getMetrics();
        Lock lock = blob.lock();
        try {
            this.log.debug("Attempting to make blob with id: {} and path: {} permanent.", (Object)blobId, (Object)blobPath);
            blob.refresh(headers, metrics);
            AzureBlobAttributes blobAttributes = new AzureBlobAttributes(this.azureClient, attributePath, headers, metrics);
            blobAttributes.store();
            AzureBlob azureBlob = blob;
            return azureBlob;
        }
        catch (IOException e) {
            this.azureClient.delete(attributePath);
            throw new BlobStoreException((Throwable)e, blobId);
        }
        finally {
            lock.unlock();
        }
    }

    public Blob getBlobFromCache(BlobId blobId) {
        return (Blob)this.liveBlobs.getUnchecked((Object)blobId);
    }

    class AzureBlob
    extends BlobSupport {
        public AzureBlob(BlobId blobId) {
            super(blobId);
        }

        public InputStream doGetInputStream() {
            try {
                return AzureBlobStore.this.azureClient.get(AzureBlobStore.this.contentPath(this.getId()));
            }
            catch (IOException e) {
                throw new BlobStoreException("caught IOException on client#get", (Throwable)e, this.getId());
            }
        }
    }
}

