/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.azure.internal.AzureClient;
import com.sonatype.nexus.blobstore.azure.internal.AzureExceptionDetector;
import com.sonatype.nexus.blobstore.azure.internal.AzureStorageClientFactory;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.ConnectionChecker;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.thread.TcclBlock;
import org.sonatype.nexus.rapture.PasswordPlaceholder;

@Singleton
@Named(value="Azure Cloud Storage")
public class AzureConnectionChecker
implements ConnectionChecker {
    private final AzureStorageClientFactory azureStorageClientFactory;
    private final BlobStoreManager blobStoreManager;

    @Inject
    public AzureConnectionChecker(AzureStorageClientFactory azureStorageClientFactory, BlobStoreManager blobStoreManager) {
        this.azureStorageClientFactory = (AzureStorageClientFactory)((Object)Preconditions.checkNotNull((Object)((Object)azureStorageClientFactory)));
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
    }

    public boolean verifyConnection(String blobStoreName, Map<String, Map<String, Object>> blobStoreAttributes) {
        String accountKey;
        String accountName = blobStoreAttributes.get("Azure Cloud Storage".toLowerCase()).get("accountName").toString();
        Object accountKeyObject = blobStoreAttributes.get("Azure Cloud Storage".toLowerCase()).get("accountKey");
        String string = accountKey = accountKeyObject == null ? null : accountKeyObject.toString();
        if (PasswordPlaceholder.is((String)accountKey)) {
            accountKey = ((Map)this.blobStoreManager.get(blobStoreName).getBlobStoreConfiguration().getAttributes().get("Azure Cloud Storage".toLowerCase())).get("accountKey").toString();
        }
        String containerName = blobStoreAttributes.get("Azure Cloud Storage".toLowerCase()).get("containerName").toString();
        String authenticationMethod = blobStoreAttributes.get("Azure Cloud Storage".toLowerCase()).get("authenticationMethod").toString();
        return this.verifyConnection(accountName, accountKey, containerName, authenticationMethod);
    }

    public boolean verifyConnection(String accountName, String accountKey, String containerName, String authenticationMethod) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (TcclBlock tccl = TcclBlock.begin(this.getClass());){
            AzureClient azureClient = this.azureStorageClientFactory.create(accountName, accountKey, containerName, authenticationMethod);
            try {
                return azureClient.containerExists();
            }
            catch (RuntimeException e) {
                throw AzureExceptionDetector.mapConnectionConfigurationException(e, authenticationMethod);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

