/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.azure.internal.AzureConfigurationConstants;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.sonatype.nexus.blobstore.BlobStoreConfigurationBuilder;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.common.collect.NestedAttributesMap;

public class AzureBlobStoreConfigurationBuilder
extends BlobStoreConfigurationBuilder {
    private String accountName;
    private Optional<String> accountKey = Optional.empty();
    private Optional<String> authenticationMethod = Optional.empty();
    private String containerName;
    private Optional<String> endpoint = Optional.empty();

    private AzureBlobStoreConfigurationBuilder(Supplier<BlobStoreConfiguration> configuration, String name) {
        super(name, configuration);
        super.type("Azure Cloud Storage");
    }

    public AzureBlobStoreConfigurationBuilder accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public AzureBlobStoreConfigurationBuilder accountKey(String accountKey) {
        this.accountKey = Optional.ofNullable(accountKey);
        return this;
    }

    public AzureBlobStoreConfigurationBuilder authenticationMethod(String authenticationMethod) {
        Preconditions.checkArgument((authenticationMethod == null || AzureConfigurationConstants.VALID_AUTHENTICATION_TYPES.contains(authenticationMethod) ? 1 : 0) != 0);
        this.authenticationMethod = Optional.ofNullable(authenticationMethod);
        return this;
    }

    public AzureBlobStoreConfigurationBuilder containerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    @VisibleForTesting
    public AzureBlobStoreConfigurationBuilder endpoint(String endpoint) {
        this.endpoint = Optional.ofNullable(endpoint);
        return this;
    }

    public BlobStoreConfigurationBuilder type(String type) {
        throw new IllegalStateException("The type cannot be changed.");
    }

    public BlobStoreConfiguration build() {
        BlobStoreConfiguration configuration = super.build();
        NestedAttributesMap azure = configuration.attributes(AzureConfigurationConstants.CONFIG_KEY);
        azure.set("accountName", Preconditions.checkNotNull((Object)this.accountName));
        azure.set("containerName", Preconditions.checkNotNull((Object)this.containerName));
        if (this.authenticationMethod.isPresent()) {
            this.authenticationMethod.ifPresent(AzureBlobStoreConfigurationBuilder.set(azure, "authenticationMethod"));
            this.accountKey.ifPresent(AzureBlobStoreConfigurationBuilder.set(azure, "accountKey"));
        }
        this.endpoint.ifPresent(AzureBlobStoreConfigurationBuilder.set(azure, "endpoint"));
        return configuration;
    }

    private static Consumer<Object> set(NestedAttributesMap attributes, String key) {
        return value -> {
            Object object = attributes.set(key, value);
        };
    }

    public static AzureBlobStoreConfigurationBuilder builder(BlobStoreConfiguration configuration, String name) {
        return new AzureBlobStoreConfigurationBuilder(() -> configuration, name);
    }

    public static AzureBlobStoreConfigurationBuilder builder(Supplier<BlobStoreConfiguration> configuration, String name) {
        return new AzureBlobStoreConfigurationBuilder(configuration, name);
    }
}

