/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.HttpGetterInfo;
import com.azure.storage.blob.implementation.models.BlobsDownloadHeaders;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobDownloadHeaders;
import com.azure.storage.blob.models.DownloadRetryOptions;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Deprecated
final class ReliableDownload {
    private static final ClientLogger LOGGER = new ClientLogger(ReliableDownload.class);
    private final StreamResponse rawResponse;
    private final BlobsDownloadHeaders deserializedHeaders;
    private final DownloadRetryOptions options;
    private final HttpGetterInfo info;
    private final Function<HttpGetterInfo, Mono<ReliableDownload>> getter;

    ReliableDownload(StreamResponse rawResponse, DownloadRetryOptions options, HttpGetterInfo info, Function<HttpGetterInfo, Mono<ReliableDownload>> getter) {
        StorageImplUtils.assertNotNull("getter", getter);
        StorageImplUtils.assertNotNull("info", info);
        this.rawResponse = rawResponse;
        this.deserializedHeaders = ModelHelper.transformBlobDownloadHeaders(rawResponse.getHeaders());
        this.options = options == null ? new DownloadRetryOptions() : options;
        this.info = info;
        this.getter = getter;
        if (this.info.getCount() == null) {
            long blobLength = ModelHelper.getBlobLength(ModelHelper.populateBlobDownloadHeaders(this.deserializedHeaders, ModelHelper.getErrorCode(rawResponse.getHeaders())));
            info.setCount(blobLength - info.getOffset());
        }
    }

    HttpRequest getRequest() {
        return this.rawResponse.getRequest();
    }

    int getStatusCode() {
        return this.rawResponse.getStatusCode();
    }

    HttpHeaders getHeaders() {
        return this.rawResponse.getHeaders();
    }

    BlobDownloadHeaders getDeserializedHeaders() {
        return ModelHelper.populateBlobDownloadHeaders(this.deserializedHeaders, ModelHelper.getErrorCode(this.rawResponse.getHeaders()));
    }

    Flux<ByteBuffer> getValue() {
        Flux<ByteBuffer> value = this.options.getMaxRetryRequests() == 0 ? this.rawResponse.getValue() : this.applyReliableDownload((Flux<ByteBuffer>)this.rawResponse.getValue(), -1, this.options);
        return value.switchIfEmpty(Flux.defer(() -> Flux.just(ByteBuffer.wrap(new byte[0]))));
    }

    private Flux<ByteBuffer> tryContinueFlux(Throwable t, int retryCount, DownloadRetryOptions options) {
        if (retryCount >= options.getMaxRetryRequests() || !(t instanceof IOException) && !(t instanceof TimeoutException)) {
            return Flux.error(t);
        }
        try {
            return this.getter.apply(this.info).flatMapMany(newResponse -> this.applyReliableDownload((Flux<ByteBuffer>)newResponse.rawResponse.getValue(), retryCount, options));
        }
        catch (Exception e) {
            return Flux.error(e);
        }
    }

    private Flux<ByteBuffer> applyReliableDownload(Flux<ByteBuffer> data, int currentRetryCount, DownloadRetryOptions options) {
        return data.doOnNext(buffer -> {
            this.info.setOffset(this.info.getOffset() + (long)buffer.remaining());
            if (this.info.getCount() != null) {
                this.info.setCount(this.info.getCount() - (long)buffer.remaining());
            }
        }).onErrorResume(t2 -> {
            if (this.info.getCount() != null && this.info.getCount() == 0L) {
                LOGGER.warning("Exception encountered in ReliableDownload after all data read from the network but but before stream signaled completion. Returning success as all data was downloaded. Exception message: " + t2.getMessage());
                return Flux.empty();
            }
            return this.tryContinueFlux((Throwable)t2, currentRetryCount + 1, options);
        });
    }
}

