/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="null")
public final class BlobsAcquireLeaseHeaders {
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="x-ms-lease-id")
    private String xMsLeaseId;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="x-ms-client-request-id")
    private String xMsClientRequestId;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString("x-ms-version");
    private static final HttpHeaderName X_MS_LEASE_ID = HttpHeaderName.fromString("x-ms-lease-id");
    private static final HttpHeaderName X_MS_REQUEST_ID = HttpHeaderName.fromString("x-ms-request-id");

    public BlobsAcquireLeaseHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        this.xMsLeaseId = rawHeaders.getValue(X_MS_LEASE_ID);
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        if (lastModified != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        this.xMsRequestId = rawHeaders.getValue(X_MS_REQUEST_ID);
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public BlobsAcquireLeaseHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public BlobsAcquireLeaseHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getXMsLeaseId() {
        return this.xMsLeaseId;
    }

    public BlobsAcquireLeaseHeaders setXMsLeaseId(String xMsLeaseId) {
        this.xMsLeaseId = xMsLeaseId;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlobsAcquireLeaseHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public BlobsAcquireLeaseHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public BlobsAcquireLeaseHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public BlobsAcquireLeaseHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

