/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AuthenticationRecord;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.MsalAuthenticationAccount;
import com.azure.identity.implementation.util.LoggingUtil;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

public class AuthorizationCodeCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(AuthorizationCodeCredential.class);
    private final String authCode;
    private final URI redirectUri;
    private final IdentityClient identityClient;
    private final AtomicReference<MsalAuthenticationAccount> cachedToken;
    private boolean isCaeEnabledRequestCached;
    private boolean isCaeDisabledRequestCached;
    private boolean isCachePopulated;

    AuthorizationCodeCredential(String clientId, String clientSecret, String tenantId, String authCode, URI redirectUri, IdentityClientOptions identityClientOptions) {
        this.identityClient = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).clientSecret(clientSecret).identityClientOptions(identityClientOptions).build();
        this.cachedToken = new AtomicReference();
        this.authCode = authCode;
        this.redirectUri = redirectUri;
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return Mono.defer(() -> {
            this.isCachePopulated = this.isCachePopulated(request);
            if (this.isCachePopulated) {
                return this.identityClient.authenticateWithPublicClientCache(request, this.cachedToken.get()).onErrorResume(t -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithAuthorizationCode(request, this.authCode, this.redirectUri))).map(msalToken -> {
            this.cachedToken.set(new MsalAuthenticationAccount(new AuthenticationRecord(msalToken.getAuthenticationResult(), this.identityClient.getTenantId(), this.identityClient.getClientId())));
            if (request.isCaeEnabled()) {
                this.isCaeEnabledRequestCached = true;
            } else {
                this.isCaeDisabledRequestCached = true;
            }
            return msalToken;
        }).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, error));
    }

    private boolean isCachePopulated(TokenRequestContext request) {
        return this.cachedToken.get() != null && (request.isCaeEnabled() && this.isCaeEnabledRequestCached || !request.isCaeEnabled() && this.isCaeDisabledRequestCached);
    }
}

