/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.jackson.AdditionalPropertiesDeserializer;
import com.azure.core.implementation.jackson.AdditionalPropertiesSerializer;
import com.azure.core.implementation.jackson.Base64UrlSerializer;
import com.azure.core.implementation.jackson.BinaryDataDeserializer;
import com.azure.core.implementation.jackson.BinaryDataSerializer;
import com.azure.core.implementation.jackson.ByteArraySerializer;
import com.azure.core.implementation.jackson.DateTimeDeserializer;
import com.azure.core.implementation.jackson.DateTimeRfc1123Serializer;
import com.azure.core.implementation.jackson.DateTimeSerializer;
import com.azure.core.implementation.jackson.DurationSerializer;
import com.azure.core.implementation.jackson.FlatteningDeserializer;
import com.azure.core.implementation.jackson.FlatteningSerializer;
import com.azure.core.implementation.jackson.GeoJsonDeserializer;
import com.azure.core.implementation.jackson.GeoJsonSerializer;
import com.azure.core.implementation.jackson.HttpHeadersSerializer;
import com.azure.core.implementation.jackson.JacksonDatabind215;
import com.azure.core.implementation.jackson.JacksonVersion;
import com.azure.core.implementation.jackson.JsonSerializableDeserializer;
import com.azure.core.implementation.jackson.JsonSerializableSerializer;
import com.azure.core.implementation.jackson.ResponseErrorDeserializer;
import com.azure.core.implementation.jackson.XmlMapperFactory;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.json.PackageVersion;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.security.AccessController;
import java.security.PrivilegedActionException;

final class ObjectMapperFactory {
    private static final ClientLogger LOGGER = new ClientLogger(ObjectMapperFactory.class);
    final boolean useJackson215 = com.fasterxml.jackson.databind.cfg.PackageVersion.VERSION.getMinorVersion() >= 15 && PackageVersion.VERSION.getMinorVersion() >= 15;
    private boolean jackson215IsSafe = true;
    private static final boolean USE_ACCESS_HELPER = Boolean.parseBoolean(Configuration.getGlobalConfiguration().get("AZURE_JACKSON_ADAPTER_USE_ACCESS_HELPER"));
    public static final ObjectMapperFactory INSTANCE = new ObjectMapperFactory();

    ObjectMapperFactory() {
    }

    public ObjectMapper createJsonMapper(ObjectMapper innerMapper) {
        ObjectMapper flatteningMapper = this.attemptJackson215Mutation((ObjectMapper)((JsonMapper.Builder)((JsonMapper.Builder)ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).addModule(FlatteningSerializer.getModule(innerMapper))).addModule(FlatteningDeserializer.getModule(innerMapper))).build());
        return this.attemptJackson215Mutation((ObjectMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).addModule(AdditionalPropertiesSerializer.getModule(flatteningMapper))).addModule(AdditionalPropertiesDeserializer.getModule(flatteningMapper))).addModule(FlatteningSerializer.getModule(innerMapper))).addModule(FlatteningDeserializer.getModule(innerMapper))).addModule(JsonSerializableSerializer.getModule())).addModule(JsonSerializableDeserializer.getModule())).addModule(ResponseErrorDeserializer.getModule(innerMapper))).build());
    }

    public ObjectMapper createXmlMapper() {
        return this.attemptJackson215Mutation(XmlMapperFactory.INSTANCE.createXmlMapper());
    }

    public ObjectMapper createSimpleMapper() {
        return this.attemptJackson215Mutation((ObjectMapper)ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).build());
    }

    public ObjectMapper createDefaultMapper() {
        return this.attemptJackson215Mutation(new ObjectMapper());
    }

    public ObjectMapper createPrettyPrintMapper() {
        return this.attemptJackson215Mutation(new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT));
    }

    public ObjectMapper createHeaderMapper() {
        return this.attemptJackson215Mutation((ObjectMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).enable(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)).addModule(JsonSerializableSerializer.getModule())).addModule(JsonSerializableDeserializer.getModule())).build());
    }

    private ObjectMapper attemptJackson215Mutation(ObjectMapper objectMapper) {
        if (this.useJackson215 && this.jackson215IsSafe) {
            try {
                if (USE_ACCESS_HELPER) {
                    try {
                        return AccessController.doPrivileged(() -> JacksonDatabind215.mutateStreamReadConstraints(objectMapper));
                    }
                    catch (PrivilegedActionException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof Error) {
                            throw (Error)cause;
                        }
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        throw new RuntimeException(ex);
                    }
                }
                return JacksonDatabind215.mutateStreamReadConstraints(objectMapper);
            }
            catch (Throwable ex) {
                if (ex instanceof LinkageError) {
                    this.jackson215IsSafe = false;
                    LOGGER.log(LogLevel.VERBOSE, JacksonVersion::getHelpInfo, ex);
                }
                throw ex;
            }
        }
        return objectMapper;
    }

    static <S extends MapperBuilder<?, ?>> S initializeMapperBuilder(S mapper) {
        ((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)mapper.enable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS)).enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS)).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).serializationInclusion(JsonInclude.Include.NON_NULL)).addModule(new JavaTimeModule())).addModule(BinaryDataSerializer.getModule())).addModule(BinaryDataDeserializer.getModule())).addModule(ByteArraySerializer.getModule())).addModule(Base64UrlSerializer.getModule())).addModule(DateTimeSerializer.getModule())).addModule(DateTimeDeserializer.getModule())).addModule(DateTimeRfc1123Serializer.getModule())).addModule(DurationSerializer.getModule())).addModule(HttpHeadersSerializer.getModule())).addModule(GeoJsonSerializer.getModule())).addModule(GeoJsonDeserializer.getModule())).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY)).visibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE)).visibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE)).visibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.NONE);
        return mapper;
    }
}

