/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.ImplUtils;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;

public final class OutputStreamWriteSubscriber
implements Subscriber<ByteBuffer> {
    private final MonoSink<Void> emitter;
    private final OutputStream stream;
    private final ClientLogger logger;
    private Subscription subscription;

    public OutputStreamWriteSubscriber(MonoSink<Void> emitter, OutputStream stream, ClientLogger logger) {
        this.emitter = emitter;
        this.stream = stream;
        this.logger = logger;
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate(this.subscription, s)) {
            this.subscription = s;
            s.request(1L);
        }
    }

    public void onNext(ByteBuffer byteBuffer) {
        try {
            ImplUtils.writeByteBufferToStream(byteBuffer, this.stream);
            this.subscription.request(1L);
        }
        catch (IOException ex) {
            this.onError(new UncheckedIOException(ex));
        }
    }

    public void onError(Throwable throwable) {
        this.subscription.cancel();
        this.emitter.error(this.logger.logThrowableAsError(throwable));
    }

    public void onComplete() {
        this.emitter.success();
    }
}

