/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpRequestLogger;
import com.azure.core.http.policy.HttpRequestLoggingContext;
import com.azure.core.http.policy.HttpResponseLogger;
import com.azure.core.http.policy.HttpResponseLoggingContext;
import com.azure.core.implementation.AccessibleByteArrayOutputStream;
import com.azure.core.implementation.ImplUtils;
import com.azure.core.implementation.jackson.ObjectMapperShim;
import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataHelper;
import com.azure.core.implementation.util.ByteArrayContent;
import com.azure.core.implementation.util.ByteBufferContent;
import com.azure.core.implementation.util.InputStreamContent;
import com.azure.core.implementation.util.SerializableContent;
import com.azure.core.implementation.util.StringContent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.azure.core.util.logging.LoggingEventBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class HttpLoggingPolicy
implements HttpPipelinePolicy {
    private static final ObjectMapperShim PRETTY_PRINTER = ObjectMapperShim.createPrettyPrintMapper();
    private static final int MAX_BODY_LOG_SIZE = 16384;
    private static final String REDACTED_PLACEHOLDER = "REDACTED";
    private static final int LOGGER_CACHE_MAX_SIZE = 1000;
    private static final Map<String, ClientLogger> CALLER_METHOD_LOGGER_CACHE = new ConcurrentHashMap<String, ClientLogger>();
    private static final ClientLogger LOGGER = new ClientLogger(HttpLoggingPolicy.class);
    private final HttpLogDetailLevel httpLogDetailLevel;
    private final Set<String> allowedHeaderNames;
    private final Set<String> allowedQueryParameterNames;
    private final boolean prettyPrintBody;
    private final HttpRequestLogger requestLogger;
    private final HttpResponseLogger responseLogger;
    public static final String RETRY_COUNT_CONTEXT = "requestRetryCount";
    private static final String REQUEST_LOG_MESSAGE = "HTTP request";
    private static final String RESPONSE_LOG_MESSAGE = "HTTP response";

    public HttpLoggingPolicy(HttpLogOptions httpLogOptions) {
        if (httpLogOptions == null) {
            this.httpLogDetailLevel = HttpLogDetailLevel.NONE;
            this.allowedHeaderNames = Collections.emptySet();
            this.allowedQueryParameterNames = Collections.emptySet();
            this.prettyPrintBody = false;
            this.requestLogger = new DefaultHttpRequestLogger();
            this.responseLogger = new DefaultHttpResponseLogger();
        } else {
            this.httpLogDetailLevel = httpLogOptions.getLogLevel();
            this.allowedHeaderNames = httpLogOptions.getAllowedHeaderNames().stream().map(headerName -> headerName.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            this.allowedQueryParameterNames = httpLogOptions.getAllowedQueryParamNames().stream().map(queryParamName -> queryParamName.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            this.prettyPrintBody = httpLogOptions.isPrettyPrintBody();
            this.requestLogger = httpLogOptions.getRequestLogger() == null ? new DefaultHttpRequestLogger() : httpLogOptions.getRequestLogger();
            this.responseLogger = httpLogOptions.getResponseLogger() == null ? new DefaultHttpResponseLogger() : httpLogOptions.getResponseLogger();
        }
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if (this.httpLogDetailLevel == HttpLogDetailLevel.NONE) {
            return next.process();
        }
        ClientLogger logger = HttpLoggingPolicy.getOrCreateMethodLogger((String)context.getData("caller-method").orElse(""));
        long startNs = System.nanoTime();
        return this.requestLogger.logRequest(logger, this.getRequestLoggingOptions(context)).then(next.process()).flatMap(response -> this.responseLogger.logResponse(logger, this.getResponseLoggingOptions((HttpResponse)response, startNs, context))).doOnError(throwable -> logger.warning("<-- HTTP FAILED: ", throwable));
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        if (this.httpLogDetailLevel == HttpLogDetailLevel.NONE) {
            return next.processSync();
        }
        ClientLogger logger = HttpLoggingPolicy.getOrCreateMethodLogger((String)context.getData("caller-method").orElse(""));
        long startNs = System.nanoTime();
        this.requestLogger.logRequestSync(logger, this.getRequestLoggingOptions(context));
        try {
            HttpResponse response = next.processSync();
            if (response != null) {
                response = this.responseLogger.logResponseSync(logger, this.getResponseLoggingOptions(response, startNs, context));
            }
            return response;
        }
        catch (RuntimeException e) {
            logger.warning("<-- HTTP FAILED: ", e);
            throw logger.logExceptionAsWarning(e);
        }
    }

    private HttpRequestLoggingContext getRequestLoggingOptions(HttpPipelineCallContext callContext) {
        return new HttpRequestLoggingContext(callContext.getHttpRequest(), callContext.getContext(), HttpLoggingPolicy.getRequestRetryCount(callContext.getContext()));
    }

    private HttpResponseLoggingContext getResponseLoggingOptions(HttpResponse httpResponse, long startNs, HttpPipelineCallContext callContext) {
        return new HttpResponseLoggingContext(httpResponse, Duration.ofNanos(System.nanoTime() - startNs), callContext.getContext(), HttpLoggingPolicy.getRequestRetryCount(callContext.getContext()));
    }

    private void logBody(HttpRequest request, int contentLength, LoggingEventBuilder logBuilder, ClientLogger logger, String contentType) {
        BinaryData data = request.getBodyAsBinaryData();
        BinaryDataContent content = BinaryDataHelper.getContent(data);
        if (content instanceof StringContent || content instanceof ByteBufferContent || content instanceof SerializableContent || content instanceof ByteArrayContent) {
            this.logBody(logBuilder, logger, contentType, content.toString());
        } else if (content instanceof InputStreamContent) {
            byte[] contentBytes = content.toBytes();
            request.setBody(contentBytes);
            this.logBody(logBuilder, logger, contentType, new String(contentBytes, StandardCharsets.UTF_8));
        } else {
            AccessibleByteArrayOutputStream stream = new AccessibleByteArrayOutputStream(contentLength);
            request.setBody(content.toFluxByteBuffer().doOnNext(byteBuffer -> {
                try {
                    ImplUtils.writeByteBufferToStream(byteBuffer.duplicate(), stream);
                }
                catch (IOException ex) {
                    throw LOGGER.logExceptionAsError(new UncheckedIOException(ex));
                }
            }).doFinally(ignored -> this.logBody(logBuilder, logger, contentType, stream.toString(StandardCharsets.UTF_8))));
        }
    }

    private void logBody(LoggingEventBuilder logBuilder, ClientLogger logger, String contentType, String data) {
        logBuilder.addKeyValue("body", HttpLoggingPolicy.prettyPrintIfNeeded(logger, this.prettyPrintBody, contentType, data)).log(REQUEST_LOG_MESSAGE);
    }

    private static String getRedactedUrl(URL url, Set<String> allowedQueryParameterNames) {
        String query = url.getQuery();
        if (CoreUtils.isNullOrEmpty(query)) {
            return url.toString();
        }
        UrlBuilder urlBuilder = ImplUtils.parseUrl(url, false);
        CoreUtils.parseQueryParameters(query).forEachRemaining(queryParam -> {
            if (allowedQueryParameterNames.contains(((String)queryParam.getKey()).toLowerCase(Locale.ROOT))) {
                urlBuilder.addQueryParameter((String)queryParam.getKey(), (String)queryParam.getValue());
            } else {
                urlBuilder.addQueryParameter((String)queryParam.getKey(), REDACTED_PLACEHOLDER);
            }
        });
        return urlBuilder.toString();
    }

    private static void addHeadersToLogMessage(Set<String> allowedHeaderNames, HttpHeaders headers, LoggingEventBuilder logBuilder) {
        for (HttpHeader header : headers) {
            String headerName;
            logBuilder.addKeyValue(headerName, allowedHeaderNames.contains((headerName = header.getName()).toLowerCase(Locale.ROOT)) ? header.getValue() : REDACTED_PLACEHOLDER);
        }
    }

    private static String prettyPrintIfNeeded(ClientLogger logger, boolean prettyPrintBody, String contentType, String body) {
        String result = body;
        if (prettyPrintBody && contentType != null && (contentType.startsWith("application/json") || contentType.startsWith("text/json"))) {
            try {
                JsonNode deserialized = PRETTY_PRINTER.readTree(body);
                result = PRETTY_PRINTER.writeValueAsString(deserialized);
            }
            catch (Exception e) {
                logger.warning("Failed to pretty print JSON", e);
            }
        }
        return result;
    }

    private static long getContentLength(ClientLogger logger, HttpHeaders headers) {
        long contentLength = 0L;
        String contentLengthString = headers.getValue(HttpHeaderName.CONTENT_LENGTH);
        if (CoreUtils.isNullOrEmpty(contentLengthString)) {
            return contentLength;
        }
        try {
            contentLength = Long.parseLong(contentLengthString);
        }
        catch (NullPointerException | NumberFormatException e) {
            logger.warning("Could not parse the HTTP header content-length: '{}'.", contentLengthString, e);
        }
        return contentLength;
    }

    private static boolean shouldBodyBeLogged(String contentTypeHeader, long contentLength) {
        return !"application/octet-stream".equalsIgnoreCase(contentTypeHeader) && contentLength != 0L && contentLength < 16384L;
    }

    private static Integer getRequestRetryCount(Context context) {
        Object rawRetryCount = context.getData(RETRY_COUNT_CONTEXT).orElse(null);
        if (rawRetryCount == null) {
            return null;
        }
        try {
            return Integer.valueOf(rawRetryCount.toString());
        }
        catch (NumberFormatException ex) {
            LOGGER.warning("Could not parse the request retry count: '{}'.", rawRetryCount);
            return null;
        }
    }

    private static ClientLogger getOrCreateMethodLogger(String methodName) {
        if (CALLER_METHOD_LOGGER_CACHE.size() > 1000) {
            CALLER_METHOD_LOGGER_CACHE.clear();
        }
        return CALLER_METHOD_LOGGER_CACHE.computeIfAbsent(methodName, ClientLogger::new);
    }

    private static LoggingEventBuilder getLogBuilder(LogLevel logLevel, ClientLogger logger) {
        switch (logLevel) {
            case ERROR: {
                return logger.atError();
            }
            case WARNING: {
                return logger.atWarning();
            }
            case INFORMATIONAL: {
                return logger.atInfo();
            }
        }
        return logger.atVerbose();
    }

    private final class DefaultHttpRequestLogger
    implements HttpRequestLogger {
        private DefaultHttpRequestLogger() {
        }

        @Override
        public Mono<Void> logRequest(ClientLogger logger, HttpRequestLoggingContext loggingOptions) {
            LogLevel logLevel = this.getLogLevel(loggingOptions);
            if (logger.canLogAtLevel(logLevel)) {
                this.log(logLevel, logger, loggingOptions);
            }
            return Mono.empty();
        }

        @Override
        public void logRequestSync(ClientLogger logger, HttpRequestLoggingContext loggingOptions) {
            LogLevel logLevel = this.getLogLevel(loggingOptions);
            if (logger.canLogAtLevel(logLevel)) {
                this.log(logLevel, logger, loggingOptions);
            }
        }

        private void log(LogLevel logLevel, ClientLogger logger, HttpRequestLoggingContext loggingOptions) {
            HttpRequest request = loggingOptions.getHttpRequest();
            LoggingEventBuilder logBuilder = HttpLoggingPolicy.getLogBuilder(logLevel, logger);
            if (HttpLoggingPolicy.this.httpLogDetailLevel.shouldLogUrl()) {
                logBuilder.addKeyValue("method", (Object)request.getHttpMethod()).addKeyValue("url", HttpLoggingPolicy.getRedactedUrl(request.getUrl(), HttpLoggingPolicy.this.allowedQueryParameterNames));
                Integer retryCount = loggingOptions.getTryCount();
                if (retryCount != null) {
                    logBuilder.addKeyValue("tryCount", retryCount);
                }
            }
            if (HttpLoggingPolicy.this.httpLogDetailLevel.shouldLogHeaders() && logger.canLogAtLevel(LogLevel.INFORMATIONAL)) {
                HttpLoggingPolicy.addHeadersToLogMessage(HttpLoggingPolicy.this.allowedHeaderNames, request.getHeaders(), logBuilder);
            }
            if (request.getBody() == null) {
                logBuilder.addKeyValue("contentLength", 0L).log(HttpLoggingPolicy.REQUEST_LOG_MESSAGE);
                return;
            }
            String contentType = request.getHeaders().getValue(HttpHeaderName.CONTENT_TYPE);
            long contentLength = HttpLoggingPolicy.getContentLength(logger, request.getHeaders());
            logBuilder.addKeyValue("contentLength", contentLength);
            if (HttpLoggingPolicy.this.httpLogDetailLevel.shouldLogBody() && HttpLoggingPolicy.shouldBodyBeLogged(contentType, contentLength)) {
                HttpLoggingPolicy.this.logBody(request, (int)contentLength, logBuilder, logger, contentType);
                return;
            }
            logBuilder.log(HttpLoggingPolicy.REQUEST_LOG_MESSAGE);
        }
    }

    private final class DefaultHttpResponseLogger
    implements HttpResponseLogger {
        private DefaultHttpResponseLogger() {
        }

        @Override
        public Mono<HttpResponse> logResponse(ClientLogger logger, HttpResponseLoggingContext loggingOptions) {
            long contentLength;
            String contentTypeHeader;
            LogLevel logLevel = this.getLogLevel(loggingOptions);
            HttpResponse response = loggingOptions.getHttpResponse();
            if (!logger.canLogAtLevel(logLevel)) {
                return Mono.just(response);
            }
            LoggingEventBuilder logBuilder = HttpLoggingPolicy.getLogBuilder(logLevel, logger);
            this.logContentLength(response, logBuilder);
            this.logUrl(loggingOptions, response, logBuilder);
            this.logHeaders(logger, response, logBuilder);
            if (HttpLoggingPolicy.this.httpLogDetailLevel.shouldLogBody() && HttpLoggingPolicy.shouldBodyBeLogged(contentTypeHeader = response.getHeaderValue(HttpHeaderName.CONTENT_TYPE), contentLength = HttpLoggingPolicy.getContentLength(logger, response.getHeaders()))) {
                return Mono.just(new LoggingHttpResponse(response, logBuilder, logger, (int)contentLength, contentTypeHeader, HttpLoggingPolicy.this.prettyPrintBody));
            }
            logBuilder.log(HttpLoggingPolicy.RESPONSE_LOG_MESSAGE);
            return Mono.just(response);
        }

        private void logHeaders(ClientLogger logger, HttpResponse response, LoggingEventBuilder logBuilder) {
            if (HttpLoggingPolicy.this.httpLogDetailLevel.shouldLogHeaders() && logger.canLogAtLevel(LogLevel.INFORMATIONAL)) {
                HttpLoggingPolicy.addHeadersToLogMessage(HttpLoggingPolicy.this.allowedHeaderNames, response.getHeaders(), logBuilder);
            }
        }

        private void logUrl(HttpResponseLoggingContext loggingOptions, HttpResponse response, LoggingEventBuilder logBuilder) {
            if (HttpLoggingPolicy.this.httpLogDetailLevel.shouldLogUrl()) {
                logBuilder.addKeyValue("statusCode", response.getStatusCode()).addKeyValue("url", HttpLoggingPolicy.getRedactedUrl(response.getRequest().getUrl(), HttpLoggingPolicy.this.allowedQueryParameterNames)).addKeyValue("durationMs", loggingOptions.getResponseDuration().toMillis());
            }
        }

        private void logContentLength(HttpResponse response, LoggingEventBuilder logBuilder) {
            String contentLengthString = response.getHeaderValue(HttpHeaderName.CONTENT_LENGTH);
            if (!CoreUtils.isNullOrEmpty(contentLengthString)) {
                logBuilder.addKeyValue("contentLength", contentLengthString);
            }
        }

        @Override
        public HttpResponse logResponseSync(ClientLogger logger, HttpResponseLoggingContext loggingOptions) {
            long contentLength;
            String contentTypeHeader;
            LogLevel logLevel = this.getLogLevel(loggingOptions);
            HttpResponse response = loggingOptions.getHttpResponse();
            if (!logger.canLogAtLevel(logLevel)) {
                return response;
            }
            LoggingEventBuilder logBuilder = HttpLoggingPolicy.getLogBuilder(logLevel, logger);
            this.logContentLength(response, logBuilder);
            this.logUrl(loggingOptions, response, logBuilder);
            this.logHeaders(logger, response, logBuilder);
            if (HttpLoggingPolicy.this.httpLogDetailLevel.shouldLogBody() && HttpLoggingPolicy.shouldBodyBeLogged(contentTypeHeader = response.getHeaderValue(HttpHeaderName.CONTENT_TYPE), contentLength = HttpLoggingPolicy.getContentLength(logger, response.getHeaders()))) {
                return new LoggingHttpResponse(response, logBuilder, logger, (int)contentLength, contentTypeHeader, HttpLoggingPolicy.this.prettyPrintBody);
            }
            logBuilder.log(HttpLoggingPolicy.RESPONSE_LOG_MESSAGE);
            return response;
        }
    }

    private static final class LoggingHttpResponse
    extends HttpResponse {
        private final HttpResponse actualResponse;
        private final LoggingEventBuilder logBuilder;
        private final int contentLength;
        private final ClientLogger logger;
        private final boolean prettyPrintBody;
        private final String contentTypeHeader;

        private LoggingHttpResponse(HttpResponse actualResponse, LoggingEventBuilder logBuilder, ClientLogger logger, int contentLength, String contentTypeHeader, boolean prettyPrintBody) {
            super(actualResponse.getRequest());
            this.actualResponse = actualResponse;
            this.logBuilder = logBuilder;
            this.logger = logger;
            this.contentLength = contentLength;
            this.contentTypeHeader = contentTypeHeader;
            this.prettyPrintBody = prettyPrintBody;
        }

        @Override
        public int getStatusCode() {
            return this.actualResponse.getStatusCode();
        }

        @Override
        @Deprecated
        public String getHeaderValue(String name) {
            return this.actualResponse.getHeaderValue(name);
        }

        @Override
        public String getHeaderValue(HttpHeaderName headerName) {
            return this.actualResponse.getHeaderValue(headerName);
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.actualResponse.getHeaders();
        }

        @Override
        public Flux<ByteBuffer> getBody() {
            AccessibleByteArrayOutputStream stream = new AccessibleByteArrayOutputStream(this.contentLength);
            return this.actualResponse.getBody().doOnNext(byteBuffer -> {
                try {
                    ImplUtils.writeByteBufferToStream(byteBuffer.duplicate(), stream);
                }
                catch (IOException ex) {
                    throw LOGGER.logExceptionAsError(new UncheckedIOException(ex));
                }
            }).doFinally(ignored -> this.doLog(stream.toString(StandardCharsets.UTF_8)));
        }

        @Override
        public Mono<byte[]> getBodyAsByteArray() {
            return FluxUtil.collectBytesFromNetworkResponse(this.getBody(), this.actualResponse.getHeaders());
        }

        @Override
        public Mono<String> getBodyAsString() {
            return this.getBodyAsByteArray().map(String::new);
        }

        @Override
        public Mono<String> getBodyAsString(Charset charset) {
            return this.getBodyAsByteArray().map(bytes -> new String((byte[])bytes, charset));
        }

        @Override
        public BinaryData getBodyAsBinaryData() {
            BinaryData content = this.actualResponse.getBodyAsBinaryData();
            this.doLog(content.toString());
            return content;
        }

        @Override
        public void close() {
            this.actualResponse.close();
        }

        private void doLog(String body) {
            this.logBuilder.addKeyValue("body", HttpLoggingPolicy.prettyPrintIfNeeded(this.logger, this.prettyPrintBody, this.contentTypeHeader, body)).log(HttpLoggingPolicy.RESPONSE_LOG_MESSAGE);
        }
    }
}

