/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.netty.implementation.ByteBufWriteSubscriber;
import com.azure.core.http.netty.implementation.NettyAsyncHttpResponseBase;
import com.azure.core.http.netty.implementation.Utility;
import com.azure.core.util.CoreUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Schedulers;
import reactor.netty.ByteBufFlux;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClientResponse;

public final class NettyAsyncHttpResponse
extends NettyAsyncHttpResponseBase {
    private final Connection reactorNettyConnection;
    private final boolean disableBufferCopy;

    public NettyAsyncHttpResponse(HttpClientResponse reactorNettyResponse, Connection reactorNettyConnection, HttpRequest httpRequest, boolean disableBufferCopy, boolean headersEagerlyConverted) {
        super(reactorNettyResponse, httpRequest, headersEagerlyConverted);
        this.reactorNettyConnection = reactorNettyConnection;
        this.disableBufferCopy = disableBufferCopy;
    }

    @Override
    public Flux<ByteBuffer> getBody() {
        return this.bodyIntern().map(byteBuf -> this.disableBufferCopy ? byteBuf.nioBuffer() : Utility.deepCopyBuffer(byteBuf)).doFinally(ignored -> this.close());
    }

    @Override
    public Mono<byte[]> getBodyAsByteArray() {
        return this.bodyIntern().aggregate().asByteArray().doFinally(ignored -> this.close());
    }

    @Override
    public Mono<String> getBodyAsString() {
        return this.getBodyAsByteArray().map(bytes -> CoreUtils.bomAwareToString(bytes, this.getHeaderValue(HttpHeaderName.CONTENT_TYPE)));
    }

    @Override
    public Mono<String> getBodyAsString(Charset charset) {
        return this.bodyIntern().aggregate().asString(charset).doFinally(ignored -> this.close());
    }

    @Override
    public Mono<InputStream> getBodyAsInputStream() {
        return this.bodyIntern().aggregate().asInputStream().doFinally(ignored -> this.close());
    }

    @Override
    public Mono<Void> writeBodyToAsync(AsynchronousByteChannel channel) {
        return Mono.create(sink -> this.bodyIntern().subscribe(new ByteBufWriteSubscriber(byteBuffer -> channel.write((ByteBuffer)byteBuffer).get(), (MonoSink<Void>)sink, this.getContentLength()))).doFinally(ignored -> this.close());
    }

    @Override
    public void writeBodyTo(WritableByteChannel channel) {
        Mono.create(sink -> this.bodyIntern().subscribe(new ByteBufWriteSubscriber(channel::write, (MonoSink<Void>)sink, this.getContentLength()))).subscribeOn(Schedulers.boundedElastic()).doFinally(ignored -> this.close()).block();
    }

    @Override
    public void close() {
        Utility.closeConnection(this.reactorNettyConnection);
    }

    private ByteBufFlux bodyIntern() {
        return this.reactorNettyConnection.inbound().receive();
    }

    public Connection internConnection() {
        return this.reactorNettyConnection;
    }

    private Long getContentLength() {
        String contentLength = this.getHeaders().getValue(HttpHeaderName.CONTENT_LENGTH);
        if (contentLength == null) {
            return null;
        }
        try {
            return Long.parseLong(contentLength);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

