/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.orient.internal;

import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsAbstractHostedBatchEndpointHandler;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsBatchRequestParser;
import org.sonatype.nexus.repository.gitlfs.orient.internal.OrientGitLfsHostedFacet;
import org.sonatype.nexus.repository.storage.Asset;

@Named
@Singleton
public class OrientGitLfsHostedBatchEndpointHandler
extends GitLfsAbstractHostedBatchEndpointHandler {
    @Inject
    public OrientGitLfsHostedBatchEndpointHandler(GitLfsBatchRequestParser batchRequestParser) {
        super(batchRequestParser);
    }

    @Override
    protected boolean savedContentExists(Repository repository, String oid) {
        OrientGitLfsHostedFacet hostedFacet = (OrientGitLfsHostedFacet)repository.facet(OrientGitLfsHostedFacet.class);
        return hostedFacet.getAsset(oid) != null;
    }

    @Override
    protected Optional<Long> savedContentSize(Repository repository, String oid) {
        OrientGitLfsHostedFacet hostedFacet = (OrientGitLfsHostedFacet)repository.facet(OrientGitLfsHostedFacet.class);
        Asset asset = hostedFacet.getAsset(oid);
        return asset == null ? Optional.empty() : Optional.of(asset.size());
    }
}

