/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.internal.utils;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsCoordinate;

public final class GitLfsLinkUtils {
    public static String buildDownloadLink(String repositoryUrl, GitLfsCoordinate coordinate) {
        Preconditions.checkNotNull((Object)repositoryUrl);
        Preconditions.checkNotNull((Object)coordinate);
        return String.format("%s/%s", repositoryUrl, coordinate.getOid());
    }

    public static String buildUploadLink(String repositoryUrl, GitLfsCoordinate coordinate) {
        Preconditions.checkNotNull((Object)repositoryUrl);
        Preconditions.checkNotNull((Object)coordinate);
        return String.format("%s/%s", repositoryUrl, coordinate.getOid());
    }

    public static String buildVerifyLink(String repositoryUrl, GitLfsCoordinate coordinate) {
        Preconditions.checkNotNull((Object)repositoryUrl);
        Preconditions.checkNotNull((Object)coordinate);
        return String.format("%s/%s/verify", repositoryUrl, coordinate.getOid());
    }

    private GitLfsLinkUtils() {
    }
}

