/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GitLfsCoordinate {
    private final String oid;
    private final long size;

    public GitLfsCoordinate(String oid, long size) {
        this.oid = (String)Preconditions.checkNotNull((Object)oid);
        this.size = size;
    }

    public String getOid() {
        return this.oid;
    }

    public long getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitLfsCoordinate that = (GitLfsCoordinate)o;
        return Objects.equals(this.oid, that.oid) && Objects.equals(this.size, that.size);
    }

    public int hashCode() {
        return Objects.hash(this.oid, this.size);
    }

    public String toString() {
        return "GitLfsCoordinate{oid='" + this.oid + '\'' + ", size=" + this.size + '}';
    }

    @JsonCreator
    public static GitLfsCoordinate fromJson(@JsonProperty(value="oid", required=true) String oid, @JsonProperty(value="size", required=true) long size) {
        return new GitLfsCoordinate(oid, size);
    }
}

