/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsBatchRequest;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsBatchRequestParser;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsCoordinate;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsOperation;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsTransfer;
import org.sonatype.nexus.repository.gitlfs.internal.exception.GitLfsRequestException;
import org.sonatype.nexus.repository.gitlfs.internal.utils.GitLfsJsonUtils;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public abstract class GitLfsAbstractHostedBatchEndpointHandler
implements Handler {
    private static final int EXPIRY_MINUTES = 15;
    private final ObjectMapper mapper = new ObjectMapper();
    private final GitLfsBatchRequestParser batchRequestParser;

    protected GitLfsAbstractHostedBatchEndpointHandler(GitLfsBatchRequestParser batchRequestParser) {
        this.batchRequestParser = (GitLfsBatchRequestParser)((Object)Preconditions.checkNotNull((Object)((Object)batchRequestParser)));
    }

    public Response handle(@Nonnull Context context) throws IOException {
        GitLfsBatchRequest request;
        Preconditions.checkNotNull((Object)context);
        if (!"POST".equals(context.getRequest().getAction())) {
            return new Response.Builder().status(Status.failure((int)405)).payload((Payload)new StringPayload(this.mapper.writeValueAsString(GitLfsJsonUtils.buildBatchResponse("Not Allowed")), "application/vnd.git-lfs+json")).build();
        }
        Repository repository = context.getRepository();
        Payload payload = (Payload)Preconditions.checkNotNull((Object)context.getRequest().getPayload());
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream is = payload.openInputStream();){
            request = this.batchRequestParser.parse(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!GitLfsOperation.UPLOAD.equals(request.getOperation()) && !GitLfsOperation.DOWNLOAD.equals(request.getOperation())) {
            throw new GitLfsRequestException(String.format("Only 'upload' and 'download' operations are supported (was %s)", request.getOperation()));
        }
        if (!request.getTransfers().contains(GitLfsTransfer.BASIC)) {
            throw new GitLfsRequestException(String.format("Only the 'basic' transfer adapter is supported (was %s)", request.getTransfers()));
        }
        Map<String, String> headers = GitLfsJsonUtils.buildAuthorizationHeaders(context.getRequest().getHeaders());
        List<Map<String, Object>> responseObjects = this.buildResponse(repository, request, headers);
        return HttpResponses.ok((Payload)new StringPayload(this.mapper.writeValueAsString(GitLfsJsonUtils.buildBatchResponse(GitLfsTransfer.BASIC, responseObjects)), "application/vnd.git-lfs+json"));
    }

    protected abstract boolean savedContentExists(Repository var1, String var2);

    protected abstract Optional<Long> savedContentSize(Repository var1, String var2);

    private List<Map<String, Object>> buildResponse(Repository repository, GitLfsBatchRequest request, Map<String, String> headers) {
        GitLfsOperation operation = request.getOperation();
        return request.getObjects().stream().map(coordinate -> GitLfsJsonUtils.buildObjectResponse(coordinate, this.buildObjectContents(repository, operation, (GitLfsCoordinate)coordinate, headers))).collect(Collectors.toList());
    }

    private Map<String, Object> buildObjectContents(Repository repository, GitLfsOperation operation, GitLfsCoordinate coordinate, Map<String, String> headers) {
        if (GitLfsOperation.UPLOAD.equals(operation)) {
            return this.buildObjectForUpload(repository, coordinate, headers);
        }
        if (GitLfsOperation.DOWNLOAD.equals(operation)) {
            return this.buildObjectForDownload(repository, coordinate, headers);
        }
        throw new IllegalStateException("Unexpected operation: " + operation);
    }

    private Map<String, Object> buildObjectForUpload(Repository repository, GitLfsCoordinate coordinate, Map<String, String> headers) {
        if (!this.savedContentExists(repository, coordinate.getOid())) {
            return GitLfsJsonUtils.buildObjectUploadActions(repository.getUrl(), coordinate, headers, this.buildExpiresAtTimestamp());
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> buildObjectForDownload(Repository repository, GitLfsCoordinate coordinate, Map<String, String> headers) {
        Optional<Long> contentSize = this.savedContentSize(repository, coordinate.getOid());
        if (!contentSize.isPresent()) {
            return GitLfsJsonUtils.buildObjectDownloadNotFoundError();
        }
        if (coordinate.getSize() != contentSize.get().longValue()) {
            return GitLfsJsonUtils.buildObjectDownloadSizeMismatchError(coordinate);
        }
        return GitLfsJsonUtils.buildObjectDownloadActions(repository.getUrl(), coordinate, headers, this.buildExpiresAtTimestamp());
    }

    private DateTime buildExpiresAtTimestamp() {
        return DateTime.now().plusMinutes(15);
    }
}

