/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.datastore.internal;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.gitlfs.datastore.GitLfsContentFacet;
import org.sonatype.nexus.repository.gitlfs.datastore.internal.PathUtils;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsAttributes;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="gitlfs")
public class GitLfsContentFacetImpl
extends ContentFacetSupport
implements GitLfsContentFacet {
    @Inject
    public GitLfsContentFacetImpl(@Named(value="gitlfs") @Named(value="gitlfs") FormatStoreManager formatStoreManager) {
        super(formatStoreManager);
    }

    @Override
    public Optional<FluentAsset> get(String assetPath) {
        Preconditions.checkNotNull((Object)assetPath);
        return this.assets().path(PathUtils.normalizeAssetPath(assetPath)).find();
    }

    @Override
    public Optional<Content> getContent(String assetPath) {
        Preconditions.checkNotNull((Object)assetPath);
        return this.assets().path(PathUtils.normalizeAssetPath(assetPath)).find().map(FluentAsset::download);
    }

    @Override
    public Content put(String path, Payload content) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)content);
        String normalizedPath = PathUtils.normalizeAssetPath(path);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.blobs().ingest(content, GitLfsAttributes.HASH_ALGORITHMS);){
            return this.putPackage(normalizedPath, tempBlob).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private FluentAsset putPackage(String path, TempBlob tempBlob) {
        FluentComponent component = this.components().name(path).getOrCreate();
        return this.assets().path(path).component((Component)component).blob(tempBlob).save();
    }
}

