/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.datastore;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.gitlfs.datastore.GitLfsContentFacet;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Singleton
public class GitLfsHostedUploadHandler
implements Handler {
    @Nonnull
    public Response handle(@Nonnull Context context) {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String oid = (String)state.getTokens().get("oid");
        if (oid == null) {
            return HttpResponses.badRequest((String)"missed oid");
        }
        Repository repository = context.getRepository();
        GitLfsContentFacet hostedFacet = (GitLfsContentFacet)repository.facet(GitLfsContentFacet.class);
        hostedFacet.put(oid, (Payload)Preconditions.checkNotNull((Object)context.getRequest().getPayload()));
        return HttpResponses.ok();
    }
}

