/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.supportzip.ui;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.supportzip.SupportZipInfoData;
import com.sonatype.nexus.distributed.supportzip.SupportZipManager;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.log.SupportZipGeneratorRequest;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/internal/ui/supportzip")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SupportZipUiInternalResource
extends ComponentSupport
implements Resource {
    static final String RESOURCE_PATH = "/internal/ui/supportzip";
    private static final String ACTIVE_NODES_PATH = "/activenodes";
    private static final String SUPPORT_ZIP_STATUS_PATH = "/status/{nodeId}";
    private static final String CREATE_SUPPORT_ZIP_PATH = "/{nodeId}";
    private static final String CLEAR_SUPPORT_ZIP_INFO_HISTORY_PATH = "/clear/{nodeId}";
    private final SupportZipManager supportZipManager;

    @Inject
    public SupportZipUiInternalResource(SupportZipManager supportZipManager) {
        this.supportZipManager = (SupportZipManager)Preconditions.checkNotNull((Object)supportZipManager);
    }

    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:metrics:read"})
    @GET
    @Path(value="/activenodes")
    public List<SupportZipInfoData> getActiveNodesSupportZipInfo() {
        return this.supportZipManager.getActiveNodesSupportZipInfo();
    }

    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:metrics:read"})
    @GET
    @Path(value="/status/{nodeId}")
    public SupportZipInfoData getSupportZipInfo(@PathParam(value="nodeId") String nodeId) {
        return this.supportZipManager.getNodeSupportZipData(nodeId).orElse(null);
    }

    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:metrics:read"})
    @POST
    @Path(value="/{nodeId}")
    public void generateSupportZip(@PathParam(value="nodeId") String nodeId, SupportZipGeneratorRequest request) {
        Objects.requireNonNull(nodeId);
        this.supportZipManager.generateNodeSupportZip(nodeId, request);
    }

    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:metrics:read"})
    @DELETE
    @Path(value="/clear/{nodeId}")
    public void clearSupportZipInfoHistory(@PathParam(value="nodeId") String nodeId) {
        this.supportZipManager.clearSupportZipInfoHistory(nodeId);
    }
}

