/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.wonderland;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.sonatype.nexus.distributed.internal.wonderland.DistributedAuthTicketCacheStore;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.PeriodicJobService;
import org.sonatype.nexus.wonderland.AuthTicketCache;

@Priority(value=0x7FFFFFFF)
@Named
@Singleton
public class DistributedAuthTicketCache
extends StateGuardLifecycleSupport
implements AuthTicketCache {
    private static final HashFunction hash = Hashing.sha256();
    private final Duration expireAfter;
    private final DistributedAuthTicketCacheStore store;
    private final PeriodicJobService cleanUpPeriodicService;

    @Inject
    public DistributedAuthTicketCache(@Named(value="${wonderland.authTicketCache.expireAfter:-20s}") @Named(value="${wonderland.authTicketCache.expireAfter:-20s}") Duration expireAfter, DistributedAuthTicketCacheStore store, PeriodicJobService periodicJobService) {
        this.expireAfter = (Duration)Preconditions.checkNotNull((Object)expireAfter);
        this.store = (DistributedAuthTicketCacheStore)((Object)Preconditions.checkNotNull((Object)((Object)store)));
        this.cleanUpPeriodicService = (PeriodicJobService)Preconditions.checkNotNull((Object)periodicJobService);
        this.log.debug("Expire after: {}", (Object)expireAfter);
    }

    protected void doStart() throws Exception {
        this.cleanUpPeriodicService.startUsing();
        this.cleanUpPeriodicService.schedule(this::remove, Duration.ofHours(1L));
    }

    protected void doStop() throws Exception {
        this.cleanUpPeriodicService.stopUsing();
    }

    public void add(String user, String token, String realmName) {
        this.store.add(user, DistributedAuthTicketCache.hash(token), realmName);
    }

    public boolean remove(String user, String token, String realmName) {
        return this.store.remove(user, DistributedAuthTicketCache.hash(token), realmName, this.expireAfter);
    }

    private void remove() {
        int removed = this.store.removeBeforeTime(this.expireAfter);
        this.log.debug("Removed {} entries older than configured expiration", (Object)removed);
    }

    private static String hash(String token) {
        return hash.hashString((CharSequence)token, StandardCharsets.UTF_8).toString();
    }
}

