/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.tasks;

import com.google.common.base.Preconditions;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.scheduling.ExternalTaskState;
import org.sonatype.nexus.scheduling.TaskFactory;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskSchedulerImpl;
import org.sonatype.nexus.scheduling.spi.SchedulerSPI;
import org.sonatype.nexus.scheduling.spi.TaskResultStateStore;

@Singleton
@Priority(value=0x7FFFFFFF)
@Named
public class ClusteredTaskSchedulerImpl
extends TaskSchedulerImpl {
    private final TaskResultStateStore taskResultStateStore;

    @Inject
    public ClusteredTaskSchedulerImpl(EventManager eventManager, TaskFactory taskFactory, TaskResultStateStore taskResultStateStore, Provider<SchedulerSPI> scheduler) {
        super(eventManager, taskFactory, scheduler);
        this.taskResultStateStore = (TaskResultStateStore)Preconditions.checkNotNull((Object)taskResultStateStore);
    }

    public ExternalTaskState toExternalTaskState(TaskInfo taskInfo) {
        return this.taskResultStateStore.getState(taskInfo).map(clusteredTaskStates -> new ExternalTaskState(clusteredTaskStates.getState(), clusteredTaskStates.getNextFireTime(), clusteredTaskStates.getLastEndState(), clusteredTaskStates.getLastRunStarted(), clusteredTaskStates.getLastRunDuration(), clusteredTaskStates.getProgress())).orElseGet(() -> new ExternalTaskState(taskInfo));
    }
}

