/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.supportzip.cleanup;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class SupportZipCleanupTaskManager
extends LifecycleSupport {
    @VisibleForTesting
    static final String DAILY_CRON = "0 0 1 * * ?";
    @VisibleForTesting
    static final String TASK_NAME = "Cleanup support zip service";
    private final TaskScheduler taskScheduler;

    @Inject
    public SupportZipCleanupTaskManager(TaskScheduler taskScheduler) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    protected void doStart() throws Exception {
        if (!this.doesTaskExist()) {
            TaskConfiguration taskConfig = this.taskScheduler.createTaskConfigurationInstance("supportzip.cleanup");
            taskConfig.setName(TASK_NAME);
            Cron run1amEveryDay = this.taskScheduler.getScheduleFactory().cron(new Date(), DAILY_CRON);
            this.taskScheduler.scheduleTask(taskConfig, (Schedule)run1amEveryDay);
            this.log.debug("Cleanup support zip task scheduled");
        }
        this.removeDuplicates();
    }

    private boolean doesTaskExist() {
        return this.taskScheduler.listsTasks().stream().anyMatch(SupportZipCleanupTaskManager::isCleanupTask);
    }

    private void removeDuplicates() {
        List tasks = this.taskScheduler.listsTasks().stream().filter(SupportZipCleanupTaskManager::isCleanupTask).filter(info -> TASK_NAME.equals(info.getConfiguration().getName())).filter(this.scheduleMatches()).sorted(Comparator.comparing(TaskInfo::getId)).collect(Collectors.toList());
        if (tasks.size() > 1) {
            tasks.subList(1, tasks.size()).forEach(TaskInfo::remove);
        }
    }

    private static boolean isCleanupTask(TaskInfo info) {
        return "supportzip.cleanup".equals(info.getConfiguration().getTypeId());
    }

    private Predicate<TaskInfo> scheduleMatches() {
        Cron cron = this.taskScheduler.getScheduleFactory().cron(new Date(), DAILY_CRON);
        return taskInfo -> {
            Schedule schedule = taskInfo.getSchedule();
            return schedule instanceof Cron && cron.getCronExpression().equals(((Cron)schedule).getCronExpression());
        };
    }
}

