/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.supportzip.cleanup;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.supportzip.NewHADownloadService;
import com.sonatype.nexus.distributed.internal.supportzip.store.SupportZipInfoStore;
import com.sonatype.nexus.distributed.supportzip.SupportZipCleanupService;
import com.sonatype.nexus.distributed.supportzip.SupportZipInfoData;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;

@Named
@Singleton
public class SupportZipCleanupServiceImpl
extends ComponentSupport
implements SupportZipCleanupService {
    private static final String DIRECT_PATH_BLOB_PREFIX = "nexus-blobstore-download-service";
    private static final Pattern SUPPORT_ZIP_BLOB_PATTERN = Pattern.compile("nexus-blobstore-download-service/nodeID-(.*)-timestamp-(.*)-\\d+\\.zip");
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
    private static final long EXPIRY_IN_DAYS = 7L;
    private final Logger auditLogger = LoggerFactory.getLogger((String)"auditlog");
    private final SupportZipInfoStore supportZipInfoStore;
    private final Provider<BlobStoreManager> blobStoreManagerProvider;

    @Inject
    public SupportZipCleanupServiceImpl(SupportZipInfoStore supportZipInfoStore, Provider<BlobStoreManager> blobStoreManagerProvider) {
        this.supportZipInfoStore = (SupportZipInfoStore)((Object)Preconditions.checkNotNull((Object)((Object)supportZipInfoStore)));
        this.blobStoreManagerProvider = (Provider)Preconditions.checkNotNull(blobStoreManagerProvider);
    }

    @Override
    public void deleteOldSupportZips() {
        LocalDateTime now = LocalDateTime.now();
        for (BlobStore blobStore : ((BlobStoreManager)this.blobStoreManagerProvider.get()).browse()) {
            String blobstoreName = blobStore.getBlobStoreConfiguration().getName();
            List<BlobId> blobIds = blobStore.getDirectPathBlobIdStream(DIRECT_PATH_BLOB_PREFIX).collect(Collectors.toList());
            blobIds.forEach(blobId -> {
                BlobAttributes blobAttributes = blobStore.getBlobAttributes(blobId);
                String blobName = (String)blobAttributes.getHeaders().get("BlobStore.blob-name");
                Matcher matcher = SUPPORT_ZIP_BLOB_PATTERN.matcher(blobName);
                if (matcher.matches()) {
                    String blobNodeId = matcher.group(1);
                    String timestamp = matcher.group(2);
                    String blobPath = this.getBlobPath(blobstoreName, (BlobId)blobId);
                    try {
                        LocalDateTime date = LocalDateTime.parse(timestamp, FORMATTER);
                        if (this.isCreatedWeekAgo(date, now)) {
                            this.log.info("Removing old support zip from blob {}.", (Object)blobPath);
                            this.maybeRemoveSupportZipStatus(blobNodeId, (BlobId)blobId);
                            blobStore.deleteHard(blobId);
                            this.log.debug("Support zip {} was removed.", (Object)blobPath);
                            this.auditLogger.info(TaskLoggingMarkers.AUDIT_LOG_ONLY, "Support zip {} was removed.", (Object)blobPath);
                        }
                    }
                    catch (Exception e) {
                        this.log.warn("Could not remove support zip {}, exception: {}", new Object[]{blobPath, e.getMessage(), this.log.isDebugEnabled() ? e : null});
                    }
                }
            });
        }
    }

    private void maybeRemoveSupportZipStatus(String blobNodeId, BlobId blobId) {
        Optional<SupportZipInfoData> supportZipInfoDataOpt = this.supportZipInfoStore.readSupportZipInfo(blobNodeId);
        if (supportZipInfoDataOpt.isPresent()) {
            String blobRef = supportZipInfoDataOpt.get().getBlobRef();
            if (this.getBlobName(blobId).equals(blobRef)) {
                this.supportZipInfoStore.removeSupportZipInfo(blobNodeId);
            }
        }
    }

    private boolean isCreatedWeekAgo(LocalDateTime createdDate, LocalDateTime now) {
        long delta = ChronoUnit.DAYS.between(createdDate, now);
        return delta >= 7L;
    }

    private String getBlobPath(String blobstoreName, BlobId blobId) {
        String blobName = this.getBlobName(blobId);
        return NewHADownloadService.getBlobPath(blobstoreName, blobName);
    }

    private String getBlobName(BlobId blobId) {
        return blobId.toString().replace("path$nexus-blobstore-download-service/", "");
    }
}

