/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.supportzip;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.distributed.internal.supportzip.store.SupportZipInfoStore;
import com.sonatype.nexus.distributed.supportzip.Status;
import com.sonatype.nexus.distributed.supportzip.SupportZipInfoData;
import com.sonatype.nexus.distributed.supportzip.SupportZipManager;
import com.sonatype.nexus.pro.systemchecks.heartbeat.NodeHeartbeatStore;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.log.SupportZipGeneratorRequest;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.distributed.event.service.api.common.SupportZipGenerationEvent;
import org.sonatype.nexus.supportzip.SupportZipGenerator;

@Named
@Singleton
public class SupportZipManagerImpl
extends ComponentSupport
implements SupportZipManager,
EventAware,
EventAware.Asynchronous {
    private final NodeHeartbeatStore nodeHeartbeatStore;
    private final NodeAccess nodeAccess;
    private final SupportZipInfoStore supportZipInfoStore;
    private final EventManager eventManager;
    private final SupportZipGenerator supportZipGenerator;

    @Inject
    public SupportZipManagerImpl(NodeHeartbeatStore nodeHeartbeatStore, NodeAccess nodeAccess, SupportZipInfoStore supportZipInfoStore, EventManager eventManager, SupportZipGenerator supportZipGenerator) {
        this.nodeHeartbeatStore = (NodeHeartbeatStore)Preconditions.checkNotNull((Object)nodeHeartbeatStore);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.supportZipInfoStore = (SupportZipInfoStore)((Object)Preconditions.checkNotNull((Object)((Object)supportZipInfoStore)));
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.supportZipGenerator = (SupportZipGenerator)Preconditions.checkNotNull((Object)supportZipGenerator);
    }

    @Override
    public List<SupportZipInfoData> getActiveNodesSupportZipInfo() {
        List nodes = this.nodeHeartbeatStore.getActiveNodes();
        List<SupportZipInfoData> activeNodesInfo = nodes.stream().map(heartbeatData -> new SupportZipInfoData((String)heartbeatData.nodeInfo().get("nodeId"), heartbeatData.hostname())).collect(Collectors.toList());
        return activeNodesInfo;
    }

    @Override
    public void generateNodeSupportZip(String recipientNodeId, SupportZipGeneratorRequest request) {
        this.eventManager.post((Object)new SupportZipGenerationEvent(recipientNodeId, request));
    }

    @Subscribe
    public void on(SupportZipGenerationEvent event) {
        String nodeId = this.nodeAccess.getId();
        String recipientNodeId = event.getRecipientNodeId();
        if (nodeId.equals(event.getRecipientNodeId())) {
            this.runSupportZipGeneration(event.getRequest(), nodeId);
        } else if (!this.isActive(recipientNodeId)) {
            this.log.warn("Received SupportZip request but node is no longer active - {}", (Object)recipientNodeId);
            this.createOrUpdateSupportZipInfoData(recipientNodeId, event.getRequest().getHostname(), Status.NODE_UNAVAILABLE);
        }
    }

    private boolean isActive(String nodeId) {
        return this.nodeHeartbeatStore.getActiveNodes().stream().anyMatch(nodeHeartbeatData -> nodeId.equals(nodeHeartbeatData.nodeInfo().get("nodeId")));
    }

    @Override
    public Optional<SupportZipInfoData> getNodeSupportZipData(String nodeId) {
        return this.supportZipInfoStore.readSupportZipInfo(nodeId);
    }

    @Override
    public void clearSupportZipInfoHistory(String nodeId) {
        this.supportZipInfoStore.removeSupportZipInfo(nodeId);
    }

    private void runSupportZipGeneration(SupportZipGeneratorRequest request, String nodeId) {
        SupportZipInfoData data = this.createOrUpdateSupportZipInfoData(nodeId, request.getHostname(), Status.CREATING);
        SupportZipGenerator.Result result = this.supportZipGenerator.generate(request, String.format("nodeID-%s-timestamp-", nodeId));
        if (Objects.isNull(result)) {
            data.setStatus(Status.FAILED);
        } else {
            data.setStatus(Status.COMPLETED);
            data.setBlobRef(result.getFilename());
        }
        data.setLastUpdated(OffsetDateTime.now());
        this.supportZipInfoStore.updateSupportZipInfo(data);
    }

    private SupportZipInfoData createOrUpdateSupportZipInfoData(String nodeId, String hostname, Status status) {
        Optional<SupportZipInfoData> tableEntry = this.supportZipInfoStore.readSupportZipInfo(nodeId);
        SupportZipInfoData data = tableEntry.orElseGet(SupportZipInfoData::new);
        data.setNodeId(nodeId);
        data.setHostname(hostname);
        data.setStatus(status);
        data.setBlobRef(null);
        data.setLastUpdated(OffsetDateTime.now());
        if (tableEntry.isPresent()) {
            this.supportZipInfoStore.updateSupportZipInfo(data);
        } else {
            this.supportZipInfoStore.createSupportZipInfo(data);
            data = this.supportZipInfoStore.readSupportZipInfo(nodeId).get();
        }
        return data;
    }
}

