/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.sqlcache.store;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.sqlcache.store.CacheDAO;
import java.util.Optional;
import javax.cache.expiry.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class CacheStore
extends ConfigStoreSupport<CacheDAO> {
    private final int deleteBatchSize;

    @Inject
    protected CacheStore(DataSessionSupplier sessionSupplier, @Named(value="${nexus.content.deleteBatchSize:-1000}") @Named(value="${nexus.content.deleteBatchSize:-1000}") int deleteBatchSize) {
        super(sessionSupplier);
        Preconditions.checkState((deleteBatchSize > 0 ? 1 : 0) != 0, (Object)"Batch size should be positive");
        this.deleteBatchSize = deleteBatchSize;
    }

    @Transactional
    public Optional<Byte[]> get(String name, Byte[] key) {
        return ((CacheDAO)this.dao()).get(name, key);
    }

    @Transactional
    public void set(String name, Byte[] key, Byte[] value, Duration duration) {
        long durationInMinutes = duration.getTimeUnit().toMinutes(duration.getDurationAmount());
        ((CacheDAO)this.dao()).set(name, key, value, durationInMinutes);
    }

    @Transactional
    public void remove(String name, Byte[] key) {
        ((CacheDAO)this.dao()).remove(name, key);
    }

    public void removeStale() {
        int count;
        while ((count = this.removeStalePage()) > 0) {
        }
    }

    public void removeAll(String name) {
        int count;
        while ((count = this.removeAllPage(name)) > 0) {
        }
    }

    @Transactional
    protected int removeAllPage(String name) {
        return ((CacheDAO)this.dao()).removeAll(name, this.deleteBatchSize);
    }

    @Transactional
    protected int removeStalePage() {
        return ((CacheDAO)this.dao()).removeStale(this.deleteBatchSize);
    }
}

