/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.store;

import com.sonatype.nexus.distributed.internal.search.sql.query.SqlSearchQueryCondition;
import com.sonatype.nexus.distributed.internal.search.sql.query.SqlSearchRequest;
import com.sonatype.nexus.distributed.internal.search.sql.store.SearchRecordData;
import com.sonatype.nexus.distributed.internal.search.sql.store.SearchTableDAO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.ibatis.annotations.Param;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.search.SortDirection;
import org.sonatype.nexus.repository.search.sql.SearchResult;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class SearchStore
extends ConfigStoreSupport<SearchTableDAO> {
    private final int deleteBatchSize;

    @Inject
    public SearchStore(DataSessionSupplier sessionSupplier, @Named(value="${nexus.content.deleteBatchSize:-1000}") @Named(value="${nexus.content.deleteBatchSize:-1000}") int deleteBatchSize) {
        super(sessionSupplier, SearchTableDAO.class);
        this.deleteBatchSize = deleteBatchSize;
    }

    @Transactional
    public void save(SearchRecordData data) {
        this.log.debug("Saving {}", (Object)data);
        ((SearchTableDAO)this.dao()).save(data);
    }

    @Transactional
    public void delete(@Nonnull @Param(value="repositoryId") Integer repositoryId, @Nonnull @Param(value="componentId") Integer componentId, @Nonnull @Param(value="format") String format) {
        ((SearchTableDAO)this.dao()).delete(repositoryId, componentId, format);
    }

    @Transactional
    public void deleteComponentIds(@Nonnull @Param(value="repositoryId") Integer repositoryId, @Nonnull @Param(value="componentIds") Set<Integer> componentIds, @Nonnull @Param(value="format") String format) {
        ((SearchTableDAO)this.dao()).deleteComponentIds(repositoryId, componentIds, format);
    }

    @Transactional
    public boolean deleteAllForRepository(Integer repositoryId, String format) {
        boolean deleted = false;
        while (((SearchTableDAO)this.dao()).deleteAllForRepository(repositoryId, format, this.deleteBatchSize)) {
            this.commitChangesSoFar();
            deleted = true;
        }
        return deleted;
    }

    @Transactional
    public Collection<SearchResult> searchComponents(int limit, int offset, @Nullable SqlSearchQueryCondition filterQuery, @Nullable String sortColumnName, SortDirection sortDirection) {
        SqlSearchRequest request = this.prepareSearchRequest(limit, offset, filterQuery, sortColumnName, sortDirection);
        this.log.debug("Search request - filters: {}, filter values: {}, limit: {}, offset: {}, sort column: {}, sort direction: {}", new Object[]{request.filter, request.filterParams, request.limit, request.offset, request.sortColumnName, request.sortDirection});
        return ((SearchTableDAO)this.dao()).searchComponents(request);
    }

    @Transactional
    public long count(@Nullable SqlSearchQueryCondition filterQuery) {
        String filterFormat = null;
        Map<String, String> formatValues = null;
        if (Objects.nonNull(filterQuery)) {
            filterFormat = filterQuery.getSqlConditionFormat();
            formatValues = filterQuery.getValues();
        }
        this.log.debug("Search request - filters: {}, filter values: {}", (Object)filterFormat, formatValues);
        return ((SearchTableDAO)this.dao()).count(filterFormat, formatValues);
    }

    @Transactional
    public void saveBatch(List<SearchRecordData> searchData) {
        this.log.trace("Saving {} records into the search table", (Object)searchData.size());
        ((SearchTableDAO)this.dao()).saveBatch(searchData);
    }

    @Transactional
    public boolean repositoryNeedsReindex(String repositoryName) {
        return !((SearchTableDAO)this.dao()).hasRepositoryEntries(repositoryName);
    }

    private void commitChangesSoFar() {
        Transaction tx = UnitOfWork.currentTx();
        tx.commit();
        tx.begin();
        CancelableHelper.checkCancellation();
    }

    private SqlSearchRequest prepareSearchRequest(int limit, int offset, SqlSearchQueryCondition filterQuery, @Nullable String sortColumnName, SortDirection sortDirectionEnum) {
        String filterFormat = null;
        Map<String, String> formatValues = null;
        if (Objects.nonNull(filterQuery)) {
            filterFormat = filterQuery.getSqlConditionFormat();
            formatValues = filterQuery.getValues();
        }
        String sortDirection = Optional.ofNullable(sortDirectionEnum).orElse(SortDirection.ASC).name();
        return SqlSearchRequest.builder().limit(limit).offset(offset).searchFilter(filterFormat).searchFilterValues(formatValues).sortColumnName(sortColumnName).sortDirection(sortDirection).build();
    }
}

