/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.store;

import com.google.common.base.Preconditions;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.search.sql.SearchRecord;

public class SearchRecordData
implements SearchRecord {
    private Integer repositoryId;
    private Integer componentId;
    private String format;
    private String namespace;
    private String componentName;
    private Set<String> aliasComponentNames = new HashSet<String>();
    private String componentKind;
    private String version;
    private String normalisedVersion;
    private OffsetDateTime lastModified;
    private String repositoryName;
    private final Set<String> uploaders = new HashSet<String>();
    private final Set<String> uploaderIps = new HashSet<String>();
    private final Set<String> paths = new HashSet<String>();
    private final List<String> keywords = new ArrayList<String>();
    private final Set<String> md5 = new HashSet<String>();
    private final Set<String> sha1 = new HashSet<String>();
    private final Set<String> sha256 = new HashSet<String>();
    private final Set<String> sha512 = new HashSet<String>();
    private final Set<String> formatFieldValues1 = new HashSet<String>();
    private final Set<String> formatFieldValues2 = new HashSet<String>();
    private final Set<String> formatFieldValues3 = new HashSet<String>();
    private final Set<String> formatFieldValues4 = new HashSet<String>();
    private final Set<String> formatFieldValues5 = new HashSet<String>();
    private final Set<String> formatFieldValues6 = new HashSet<String>();
    private final Set<String> formatFieldValues7 = new HashSet<String>();
    private NestedAttributesMap attributes = new NestedAttributesMap("attributes", new HashMap());
    private boolean prerelease;
    private Integer entityVersion;
    private final Set<String> tags = new HashSet<String>();

    public SearchRecordData() {
    }

    public SearchRecordData(Integer repositoryId, String format) {
        this(repositoryId, null, format);
    }

    public SearchRecordData(Integer repositoryId, Integer componentId, String format) {
        this.repositoryId = repositoryId;
        this.componentId = componentId;
        this.format = format;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getComponentId() {
        return this.componentId;
    }

    public void setComponentId(Integer componentId) {
        this.componentId = componentId;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public Collection<String> getAliasComponentNames() {
        return Collections.unmodifiableCollection(this.aliasComponentNames);
    }

    public void addAliasComponentName(String aliasComponentName) {
        if (StringUtils.isNotBlank((CharSequence)aliasComponentName)) {
            this.aliasComponentNames.add(aliasComponentName);
        }
    }

    public String getComponentKind() {
        return this.componentKind;
    }

    public void setComponentKind(String componentKind) {
        this.componentKind = componentKind;
    }

    public String getVersion() {
        return this.version;
    }

    public void setNormalisedVersion(String normalisedVersion) {
        this.normalisedVersion = normalisedVersion;
    }

    public String getNormalisedVersion() {
        return this.normalisedVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void addKeywords(List<String> values) {
        if (values != null) {
            for (String value : values) {
                this.addKeyword(value);
            }
        }
    }

    public void addKeyword(String value) {
        if (StringUtils.isNotBlank((CharSequence)value) && !this.keywords.contains(value)) {
            this.keywords.add(value);
        }
    }

    public Collection<String> getKeywords() {
        return Collections.unmodifiableCollection(this.keywords);
    }

    public void addMd5(String md5) {
        if (StringUtils.isNotBlank((CharSequence)md5)) {
            this.md5.add(md5);
        }
    }

    public void addSha1(String sha1) {
        if (StringUtils.isNotBlank((CharSequence)sha1)) {
            this.sha1.add(sha1);
        }
    }

    public void addSha256(String sha256) {
        if (StringUtils.isNotBlank((CharSequence)sha256)) {
            this.sha256.add(sha256);
        }
    }

    public void addSha512(String sha512) {
        if (StringUtils.isNotBlank((CharSequence)sha512)) {
            this.sha512.add(sha512);
        }
    }

    public Collection<String> getMd5() {
        return Collections.unmodifiableCollection(this.md5);
    }

    public Collection<String> getSha1() {
        return Collections.unmodifiableCollection(this.sha1);
    }

    public Collection<String> getSha256() {
        return Collections.unmodifiableCollection(this.sha256);
    }

    public Collection<String> getSha512() {
        return Collections.unmodifiableCollection(this.sha512);
    }

    public void addFormatFieldValue1(String formatFieldValue1) {
        if (StringUtils.isNotBlank((CharSequence)formatFieldValue1)) {
            this.formatFieldValues1.add(formatFieldValue1);
        }
    }

    public Collection<String> getFormatFieldValues1() {
        return Collections.unmodifiableCollection(this.formatFieldValues1);
    }

    public void addFormatFieldValue2(String formatFieldValue2) {
        if (StringUtils.isNotBlank((CharSequence)formatFieldValue2)) {
            this.formatFieldValues2.add(formatFieldValue2);
        }
    }

    public Collection<String> getFormatFieldValues2() {
        return Collections.unmodifiableCollection(this.formatFieldValues2);
    }

    public void addFormatFieldValue3(String formatFieldValue3) {
        if (StringUtils.isNotBlank((CharSequence)formatFieldValue3)) {
            this.formatFieldValues3.add(formatFieldValue3);
        }
    }

    public Collection<String> getFormatFieldValues3() {
        return Collections.unmodifiableCollection(this.formatFieldValues3);
    }

    public void addFormatFieldValue4(String formatFieldValues4) {
        if (StringUtils.isNotBlank((CharSequence)formatFieldValues4)) {
            this.formatFieldValues4.add(formatFieldValues4);
        }
    }

    public Collection<String> getFormatFieldValues4() {
        return Collections.unmodifiableCollection(this.formatFieldValues4);
    }

    public void addFormatFieldValue5(String formatFieldValue5) {
        if (StringUtils.isNotBlank((CharSequence)formatFieldValue5)) {
            this.formatFieldValues5.add(formatFieldValue5);
        }
    }

    public Collection<String> getFormatFieldValues5() {
        return Collections.unmodifiableCollection(this.formatFieldValues5);
    }

    public void addFormatFieldValue6(String formatFieldValues6) {
        if (StringUtils.isNotBlank((CharSequence)formatFieldValues6)) {
            this.formatFieldValues6.add(formatFieldValues6);
        }
    }

    public Collection<String> getFormatFieldValues6() {
        return Collections.unmodifiableCollection(this.formatFieldValues6);
    }

    public void addFormatFieldValue7(String formatFieldValues7) {
        if (StringUtils.isNotBlank((CharSequence)formatFieldValues7)) {
            this.formatFieldValues7.add(formatFieldValues7);
        }
    }

    public Collection<String> getFormatFieldValues7() {
        return Collections.unmodifiableCollection(this.formatFieldValues7);
    }

    public NestedAttributesMap attributes() {
        return this.attributes;
    }

    public void setAttributes(NestedAttributesMap attributes) {
        this.attributes = (NestedAttributesMap)Preconditions.checkNotNull((Object)attributes);
    }

    public void addUploader(String uploader) {
        if (StringUtils.isNotBlank((CharSequence)uploader)) {
            this.uploaders.add(uploader);
        }
    }

    public Collection<String> getUploaders() {
        return Collections.unmodifiableCollection(this.uploaders);
    }

    public void addUploaderIp(String uploaderIp) {
        if (StringUtils.isNotBlank((CharSequence)uploaderIp)) {
            this.uploaderIps.add(uploaderIp);
        }
    }

    public Collection<String> getUploaderIps() {
        return Collections.unmodifiableCollection(this.uploaderIps);
    }

    public void addPath(String path) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            this.paths.add(path);
        }
    }

    public Collection<String> getPaths() {
        return Collections.unmodifiableCollection(this.paths);
    }

    public boolean isPrerelease() {
        return this.prerelease;
    }

    public void setPrerelease(boolean prerelease) {
        this.prerelease = prerelease;
    }

    public void setEntityVersion(Integer entityVersion) {
        this.entityVersion = entityVersion;
    }

    public Integer getEntityVersion() {
        return this.entityVersion;
    }

    public void setTags(Collection<String> values) {
        if (!values.isEmpty()) {
            this.tags.addAll(values);
        }
    }

    public Collection<String> getTags() {
        return Collections.unmodifiableCollection(this.tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchRecordData tableData = (SearchRecordData)o;
        return Objects.equals(this.repositoryId, tableData.repositoryId) && Objects.equals(this.componentId, tableData.componentId) && Objects.equals(this.format, tableData.format) && Objects.equals(this.namespace, tableData.namespace) && Objects.equals(this.componentName, tableData.componentName) && Objects.equals(this.aliasComponentNames, tableData.aliasComponentNames) && Objects.equals(this.componentKind, tableData.componentKind) && Objects.equals(this.version, tableData.version) && Objects.equals(this.normalisedVersion, tableData.normalisedVersion) && Objects.equals(this.lastModified, tableData.lastModified) && Objects.equals(this.repositoryName, tableData.repositoryName) && Objects.equals(this.prerelease, tableData.prerelease) && Objects.equals(this.uploaders, tableData.uploaders) && Objects.equals(this.uploaderIps, tableData.uploaderIps) && Objects.equals(this.paths, tableData.paths) && Objects.equals(this.keywords, tableData.keywords) && Objects.equals(this.md5, tableData.md5) && Objects.equals(this.sha1, tableData.sha1) && Objects.equals(this.sha256, tableData.sha256) && Objects.equals(this.sha512, tableData.sha512) && Objects.equals(this.entityVersion, tableData.entityVersion) && Objects.equals(this.formatFieldValues1, tableData.formatFieldValues1) && Objects.equals(this.formatFieldValues2, tableData.formatFieldValues2) && Objects.equals(this.formatFieldValues3, tableData.formatFieldValues3) && Objects.equals(this.formatFieldValues4, tableData.formatFieldValues4) && Objects.equals(this.formatFieldValues5, tableData.formatFieldValues5) && Objects.equals(this.formatFieldValues6, tableData.formatFieldValues6) && Objects.equals(this.formatFieldValues7, tableData.formatFieldValues7) && Objects.equals(this.attributes, tableData.attributes) && Objects.equals(this.tags, tableData.tags);
    }

    public int hashCode() {
        return Objects.hash(this.repositoryId, this.componentId, this.format, this.namespace, this.componentName, this.aliasComponentNames, this.componentKind, this.version, this.normalisedVersion, this.lastModified, this.repositoryName, this.prerelease, this.uploaders, this.uploaderIps, this.paths, this.keywords, this.md5, this.sha1, this.sha256, this.sha512, this.entityVersion, this.formatFieldValues1, this.formatFieldValues2, this.formatFieldValues3, this.formatFieldValues4, this.formatFieldValues5, this.formatFieldValues6, this.formatFieldValues7, this.attributes, this.tags);
    }

    public String toString() {
        return new StringJoiner(", ", String.valueOf(SearchRecordData.class.getSimpleName()) + "[", "]").add("repositoryId=" + this.repositoryId).add("componentId=" + this.componentId).add("format='" + this.format + "'").add("namespace='" + this.namespace + "'").add("componentName='" + this.componentName + "'").add("aliasComponentNames='" + this.aliasComponentNames + "'").add("componentKind='" + this.componentKind + "'").add("version='" + this.version + "'").add("normalisedVersion='" + this.normalisedVersion + "'").add("lastModified=" + this.lastModified).add("repositoryName='" + this.repositoryName + "'").add("prerelease=" + this.prerelease).add("uploader='" + this.uploaders + "'").add("uploaderIp='" + this.uploaderIps + "'").add("paths='" + this.paths + "'").add("keywords='" + this.keywords + "'").add("md5='" + this.md5 + "'").add("sha1='" + this.sha1 + "'").add("sha256='" + this.sha256 + "'").add("sha512='" + this.sha512 + "'").add("entityVersion='" + this.entityVersion + "'").add("formatFieldValues1='" + this.formatFieldValues1 + "'").add("formatFieldValues2='" + this.formatFieldValues2 + "'").add("formatFieldValues3='" + this.formatFieldValues3 + "'").add("formatFieldValues4='" + this.formatFieldValues4 + "'").add("formatFieldValues5='" + this.formatFieldValues5 + "'").add("formatFieldValues6='" + this.formatFieldValues6 + "'").add("formatFieldValues7='" + this.formatFieldValues7 + "'").add("attributes='" + this.attributes + "'").add("tags='" + this.tags + "'").toString();
    }
}

