/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.query.security;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.search.sql.query.security.SearchContentSelectorSqlFilterGenerator;
import com.sonatype.nexus.distributed.internal.search.sql.query.security.SqlSearchPermissionException;
import com.sonatype.nexus.distributed.internal.search.sql.query.security.UnknownRepositoriesException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.rest.sql.SearchField;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.repository.search.sql.query.syntax.ExactTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.Expression;
import org.sonatype.nexus.repository.search.sql.query.syntax.Operand;
import org.sonatype.nexus.repository.search.sql.query.syntax.SqlClause;
import org.sonatype.nexus.repository.search.sql.query.syntax.SqlPredicate;
import org.sonatype.nexus.repository.search.sql.query.syntax.TermCollection;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorManager;

@Named
@Singleton
public class SqlSearchPermissionBuilder
extends ComponentSupport {
    private final RepositoryManager repositoryManager;
    private final SecurityHelper securityHelper;
    private final SelectorManager selectorManager;
    private final SearchContentSelectorSqlFilterGenerator contentSelectorFilterGenerator;

    @Inject
    public SqlSearchPermissionBuilder(RepositoryManager repositoryManager, SecurityHelper securityHelper, SelectorManager selectorManager, SearchContentSelectorSqlFilterGenerator contentSelectorFilterGenerator) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
        this.contentSelectorFilterGenerator = (SearchContentSelectorSqlFilterGenerator)((Object)Preconditions.checkNotNull((Object)((Object)contentSelectorFilterGenerator)));
    }

    public Optional<Expression> build(SearchRequest request) {
        Set<Repository> specifiedRepositories = this.computeSpecifiedRepositories(this.getRepositoriesInRequest(request));
        if (specifiedRepositories.isEmpty()) {
            Set<Repository> allRepositories = this.getAllRepositories();
            Set<Repository> repositoriesWithAccess = this.computeRepositoriesWithAccess(allRepositories);
            if (allRepositories.size() == repositoriesWithAccess.size()) {
                return Optional.empty();
            }
            return this.addRepositoryConditions(allRepositories, repositoriesWithAccess, request);
        }
        return this.addRepositoryConditions(specifiedRepositories, this.computeRepositoriesWithAccess(specifiedRepositories), request);
    }

    private Optional<Expression> addRepositoryConditions(Set<Repository> specifiedRepositories, Set<Repository> repositoriesWithCompleteAccess, SearchRequest request) {
        Map<SelectorConfiguration, List<Repository>> contentSelectorToRepositories = request.isCheckAuthorization() ? this.contentSelectorsApplicableFor(SqlSearchPermissionBuilder.complement(specifiedRepositories, repositoriesWithCompleteAccess)) : Collections.emptyMap();
        Optional<Expression> directAccessCondition = Optional.empty();
        Optional<Object> contentAccessCondition = Optional.empty();
        if (!repositoriesWithCompleteAccess.isEmpty()) {
            repositoriesWithCompleteAccess = repositoriesWithCompleteAccess.stream().flatMap(this::expandIfGroup).collect(Collectors.toCollection(LinkedHashSet::new));
            directAccessCondition = this.createRepositoryCondition(repositoriesWithCompleteAccess);
        }
        if (request.isCheckAuthorization() && !contentSelectorToRepositories.isEmpty()) {
            contentAccessCondition = this.createContentSelectorCondition(contentSelectorToRepositories, repositoriesWithCompleteAccess);
        }
        if (!directAccessCondition.isPresent() && !contentAccessCondition.isPresent()) {
            throw new SqlSearchPermissionException("User does not have permissions to required repositories.");
        }
        if (directAccessCondition.isPresent() && contentAccessCondition.isPresent()) {
            return Optional.of(SqlClause.create((Operand)Operand.OR, (Expression[])new Expression[]{directAccessCondition.get(), (Expression)contentAccessCondition.get()}));
        }
        return directAccessCondition.isPresent() ? directAccessCondition : contentAccessCondition;
    }

    private Optional<Expression> createRepositoryCondition(Set<Repository> repositories) {
        if (repositories.isEmpty()) {
            return Optional.empty();
        }
        Set repositoryNames = repositories.stream().map(Repository::getName).distinct().map(ExactTerm::new).collect(Collectors.toCollection(LinkedHashSet::new));
        SqlPredicate predicate = new SqlPredicate(Operand.IN, SearchField.REPOSITORY_NAME, TermCollection.create((Collection)repositoryNames));
        return Optional.of(predicate);
    }

    private Optional<Expression> createContentSelectorCondition(Map<SelectorConfiguration, List<Repository>> selectorsToRepositories, Set<Repository> fullAccessRepositories) {
        ArrayList expressions = new ArrayList();
        for (Map.Entry<SelectorConfiguration, List<Repository>> entry : selectorsToRepositories.entrySet()) {
            Set applicableRepositories = entry.getValue().stream().flatMap(this::expandIfGroup).filter(repository -> !fullAccessRepositories.contains(repository)).map(Repository::getName).collect(Collectors.toCollection(LinkedHashSet::new));
            if (applicableRepositories.isEmpty()) continue;
            this.contentSelectorFilterGenerator.createFilter(entry.getKey(), applicableRepositories).ifPresent(expressions::add);
        }
        if (expressions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SqlClause.create((Operand)Operand.OR, expressions));
    }

    private Set<Repository> computeSpecifiedRepositories(Collection<String> repositories) {
        if (repositories.isEmpty()) {
            return Collections.emptySet();
        }
        Set specifiedRepositories = repositories.stream().flatMap(this::expandWildcards).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!specifiedRepositories.isEmpty()) {
            return specifiedRepositories;
        }
        throw new UnknownRepositoriesException(repositories);
    }

    private Set<Repository> getAllRepositories() {
        return StreamSupport.stream(this.repositoryManager.browse().spliterator(), true).collect(Collectors.toSet());
    }

    private Collection<String> getRepositoriesInRequest(SearchRequest request) {
        return Stream.concat(request.getRepositories().stream(), request.getSearchFilters().stream().filter(filter -> "repository_name".equals(filter.getProperty())).map(SearchFilter::getValue).flatMap(filter -> Stream.of(filter.split(" ")))).filter(Strings2::notBlank).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Stream<Repository> expandWildcards(String repositoryName) {
        Stream<Repository> repositories = StreamSupport.stream(this.repositoryManager.browse().spliterator(), false);
        if (SqlSearchPermissionBuilder.containsWildcards(repositoryName)) {
            Pattern repoNamePatterns = SqlSearchPermissionBuilder.createPattern(repositoryName);
            return repositories.filter(repository -> repoNamePatterns.matcher(repository.getName()).matches());
        }
        return Optional.ofNullable(this.repositoryManager.get(repositoryName)).map(Stream::of).orElseGet(Stream::empty);
    }

    private Stream<Repository> expandIfGroup(Repository repository) {
        return repository.optionalFacet(GroupFacet.class).map(GroupFacet::leafMembers).map(Collection::stream).orElseGet(() -> Stream.of(repository)).distinct();
    }

    private Set<Repository> computeRepositoriesWithAccess(Set<Repository> repositories) {
        return repositories.stream().filter(repository -> this.securityHelper.anyPermitted(new Permission[]{new RepositoryViewPermission(repository.getFormat().getValue(), repository.getName(), new String[]{"read"})})).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Map<SelectorConfiguration, List<Repository>> contentSelectorsApplicableFor(Collection<Repository> repositories) {
        HashMap<SelectorConfiguration, List<Repository>> selectorToRepositories = new HashMap<SelectorConfiguration, List<Repository>>();
        repositories.forEach(repository -> this.selectorManager.browseActive(Collections.singleton(repository.getName()), Collections.singleton(repository.getFormat().getValue())).stream().forEach(selector -> {
            boolean bl = selectorToRepositories.computeIfAbsent((SelectorConfiguration)selector, __ -> new ArrayList()).add(repository);
        }));
        return selectorToRepositories;
    }

    private static Pattern createPattern(String filter) {
        return Pattern.compile(filter.replace("?", ".").replace("*", ".*"));
    }

    private static boolean containsWildcards(String filter) {
        return filter.contains("*") || filter.contains("?");
    }

    private static <E> Set<E> complement(Set<E> setA, Set<E> setB) {
        return setA.stream().filter(entry -> !setB.contains(entry)).collect(Collectors.toSet());
    }
}

