/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.query.security;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.rest.sql.SearchField;
import org.sonatype.nexus.repository.search.sql.SearchMappingService;
import org.sonatype.nexus.repository.search.sql.query.syntax.Expression;
import org.sonatype.nexus.repository.search.sql.query.syntax.Operand;
import org.sonatype.nexus.repository.search.sql.query.syntax.SqlClause;
import org.sonatype.nexus.repository.search.sql.query.syntax.SqlPredicate;
import org.sonatype.nexus.repository.search.sql.query.syntax.Term;

public class SelectorExpressionBuilder
extends ComponentSupport {
    private List<Object> elements = new ArrayList<Object>();
    private final SearchMappingService mappingService;
    private final Map<String, SearchField> propertyAliases = new HashMap<String, SearchField>();

    public SelectorExpressionBuilder(SearchMappingService mappingService) {
        this.mappingService = (SearchMappingService)Preconditions.checkNotNull((Object)mappingService);
    }

    public SelectorExpressionBuilder propertyAlias(String name, SearchField field) {
        this.propertyAliases.put((String)Preconditions.checkNotNull((Object)name), (SearchField)Preconditions.checkNotNull((Object)field));
        return this;
    }

    public SelectorExpressionBuilder appendOperand(Operand op) {
        this.elements.add(op);
        return this;
    }

    public SelectorExpressionBuilder appendField(String fieldName) {
        this.elements.add(this.lookup(fieldName));
        return this;
    }

    public SelectorExpressionBuilder appendTerm(Term term) {
        this.elements.add(term);
        return this;
    }

    public SelectorExpressionBuilder appendExpression(Runnable runnable) {
        List<Object> temp = this.elements;
        this.elements = new ArrayList<Object>();
        runnable.run();
        Expression exp = this.build();
        this.elements = temp;
        this.elements.add(exp);
        return this;
    }

    public Expression build() {
        try {
            List<Object> compiled = SelectorExpressionBuilder.createPredicates(this.elements);
            compiled = SelectorExpressionBuilder.createClauses(compiled, Operand.AND);
            compiled = SelectorExpressionBuilder.createClauses(compiled, Operand.OR);
            Preconditions.checkState((compiled.size() == 1 ? 1 : 0) != 0, compiled);
            return (Expression)compiled.get(0);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Unable to create expression for: " + this.elements, e);
        }
    }

    private static List<Object> createPredicates(List<Object> elements) {
        ArrayList<Object> compiled = new ArrayList<Object>();
        ArrayList<Object> working = new ArrayList<Object>();
        for (Object element : elements) {
            Object operand;
            working.add(element);
            if (working.size() != 3) continue;
            if (working.get(1) instanceof Operand && (operand = working.get(1)) != Operand.AND && operand != Operand.OR) {
                compiled.add(new SqlPredicate((Operand)operand, (SearchField)working.get(0), (Term)working.get(2)));
                working.clear();
                continue;
            }
            compiled.add(working.remove(0));
        }
        compiled.addAll(working);
        return compiled;
    }

    private static List<Object> createClauses(List<Object> elements, Operand operand) {
        if (elements.size() == 1) {
            return elements;
        }
        ArrayList<Object> compiled = new ArrayList<Object>();
        ArrayList<Object> working = new ArrayList<Object>();
        Operand[] current = new Operand[1];
        Runnable createClause = () -> {
            boolean bl = compiled.add(SqlClause.create((Operand)operand, working.stream().map(Expression.class::cast).collect(Collectors.toList())));
        };
        Runnable consume = () -> {
            for (Object o : working) {
                compiled.add(o);
                compiled.add(current[0]);
            }
            compiled.remove(compiled.size() - 1);
        };
        for (Object element : elements) {
            if (element instanceof Operand) {
                boolean changed;
                boolean bl = changed = current[0] != null && current[0] != element;
                if (changed && current[0] == operand) {
                    createClause.run();
                    compiled.add(operand);
                    working.clear();
                } else if (changed) {
                    consume.run();
                }
                current[0] = (Operand)element;
                continue;
            }
            working.add(element);
        }
        if (!working.isEmpty()) {
            if (!compiled.isEmpty()) {
                compiled.add(current[0]);
            }
            if (current[0] == operand) {
                createClause.run();
            } else {
                consume.run();
            }
        }
        return compiled;
    }

    private SearchField lookup(String fieldName) {
        Optional field = this.mappingService.getSearchField(fieldName);
        if (field.isPresent()) {
            return (SearchField)field.get();
        }
        return Optional.ofNullable(this.propertyAliases.get(fieldName)).orElseThrow(() -> new IllegalArgumentException("Unknown field name: " + fieldName));
    }
}

