/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.query.security;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.search.sql.query.security.CselToExpression;
import com.sonatype.nexus.distributed.internal.search.sql.query.security.SelectorExpressionBuilder;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.rest.sql.SearchField;
import org.sonatype.nexus.repository.search.sql.SearchMappingService;
import org.sonatype.nexus.repository.search.sql.query.syntax.ExactTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.Expression;
import org.sonatype.nexus.repository.search.sql.query.syntax.Operand;
import org.sonatype.nexus.repository.search.sql.query.syntax.SqlClause;
import org.sonatype.nexus.repository.search.sql.query.syntax.SqlPredicate;
import org.sonatype.nexus.repository.search.sql.query.syntax.Term;
import org.sonatype.nexus.repository.search.sql.query.syntax.TermCollection;
import org.sonatype.nexus.selector.CselToSql;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorEvaluationException;
import org.sonatype.nexus.selector.SelectorManager;

@Named
@Singleton
public class SearchContentSelectorSqlFilterGenerator
extends ComponentSupport {
    public static final String PATH = "path";
    private final SelectorManager selectorManager;
    private final SearchMappingService mappingService;

    @Inject
    public SearchContentSelectorSqlFilterGenerator(SelectorManager selectorManager, SearchMappingService mappingService) {
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
        this.mappingService = (SearchMappingService)Preconditions.checkNotNull((Object)mappingService);
    }

    public Optional<Expression> createFilter(SelectorConfiguration selector, Set<String> repositories) {
        if (!"csel".equals(selector.getType())) {
            this.log.debug("Content selector is not CSEL: {}", (Object)selector.getName());
            return Optional.empty();
        }
        if (repositories.isEmpty()) {
            this.log.debug("Provided with empty set of repositores for: {}", (Object)selector.getName());
            return Optional.empty();
        }
        try {
            Expression filters = this.transformSelectorToSql(selector);
            return Optional.ofNullable(this.collectGeneratedSql(filters, repositories));
        }
        catch (SelectorEvaluationException e) {
            this.log.warn("Problem evaluating selector {} as SQL", (Object)selector.getName(), (Object)e);
            return Optional.empty();
        }
    }

    private Expression transformSelectorToSql(SelectorConfiguration selector) throws SelectorEvaluationException {
        SelectorExpressionBuilder selectorBuilder = new SelectorExpressionBuilder(this.mappingService);
        selectorBuilder.propertyAlias(PATH, SearchField.PATHS);
        CselToExpression cselToTsQuerySql = new CselToExpression();
        this.selectorManager.toSql(selector, (Object)selectorBuilder, (CselToSql)cselToTsQuerySql);
        return selectorBuilder.build();
    }

    private Expression collectGeneratedSql(Expression filterExpression, Set<String> repositories) {
        return SqlClause.create((Operand)Operand.AND, (Expression[])new Expression[]{filterExpression, this.repositoryNameCondition(repositories)});
    }

    private SqlPredicate repositoryNameCondition(Set<String> repositories) {
        Term terms = TermCollection.create((Collection)repositories.stream().map(ExactTerm::new).collect(Collectors.toList()));
        return new SqlPredicate(Operand.IN, SearchField.REPOSITORY_NAME, terms);
    }
}

