/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.query.security;

import com.sonatype.nexus.distributed.internal.search.sql.query.security.SelectorExpressionBuilder;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.parser.ASTAndNode;
import org.apache.commons.jexl3.parser.ASTEQNode;
import org.apache.commons.jexl3.parser.ASTERNode;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTIdentifierAccess;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.ASTNENode;
import org.apache.commons.jexl3.parser.ASTOrNode;
import org.apache.commons.jexl3.parser.ASTReference;
import org.apache.commons.jexl3.parser.ASTReferenceExpression;
import org.apache.commons.jexl3.parser.ASTSWNode;
import org.apache.commons.jexl3.parser.ASTStringLiteral;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.ParserVisitor;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.search.sql.query.syntax.ExactTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.NullTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.Operand;
import org.sonatype.nexus.repository.search.sql.query.syntax.Term;
import org.sonatype.nexus.repository.search.sql.query.syntax.WildcardTerm;
import org.sonatype.nexus.selector.CselToSql;
import org.sonatype.nexus.selector.ParserVisitorSupport;

public class CselToExpression
extends ParserVisitorSupport
implements CselToSql<SelectorExpressionBuilder> {
    private static final String EXPECTED_STRING_LITERAL = "Expected string literal";
    public static final String TOKEN_END_REGEX = "(}|$)";
    public static final String TOKEN_START_REGEX = "(^|{)";

    public void transformCselToSql(ASTJexlScript script, SelectorExpressionBuilder builder) {
        script.childrenAccept((ParserVisitor)this, (Object)builder);
    }

    protected Object doVisit(JexlNode node, Object data) {
        throw new JexlException(node, "Expression not supported in CSEL selector, failing node is " + node.jexlInfo().toString());
    }

    protected Object visit(ASTOrNode node, Object data) {
        return this.transformOperator((JexlNode)node, Operand.OR, (SelectorExpressionBuilder)((Object)data));
    }

    protected Object visit(ASTAndNode node, Object data) {
        return this.transformOperator((JexlNode)node, Operand.AND, (SelectorExpressionBuilder)((Object)data));
    }

    protected Object visit(ASTEQNode node, Object data) {
        this.transformOperator((JexlNode)node, Operand.EQ, (SelectorExpressionBuilder)((Object)data));
        return data;
    }

    protected Object visit(ASTERNode node, Object data) {
        return this.transformMatchesOperator((JexlNode)node, (SelectorExpressionBuilder)((Object)data));
    }

    protected Object visit(ASTNENode node, Object data) {
        JexlNode leftChild = node.jjtGetChild(0);
        JexlNode rightChild = node.jjtGetChild(1);
        if (rightChild instanceof ASTStringLiteral) {
            this.transformNotEqualsOperator(leftChild, (ASTStringLiteral)rightChild, (SelectorExpressionBuilder)((Object)data));
        } else if (leftChild instanceof ASTStringLiteral) {
            this.transformNotEqualsOperator(rightChild, (ASTStringLiteral)leftChild, (SelectorExpressionBuilder)((Object)data));
        } else {
            throw new JexlException((JexlNode)node, EXPECTED_STRING_LITERAL);
        }
        return data;
    }

    protected Object visit(ASTSWNode node, Object data) {
        JexlNode leftChild = node.jjtGetChild(0);
        JexlNode rightChild = node.jjtGetChild(1);
        SelectorExpressionBuilder builder = (SelectorExpressionBuilder)((Object)data);
        if (rightChild instanceof ASTStringLiteral) {
            this.transformStartsWithOperator(leftChild, (ASTStringLiteral)rightChild, builder);
        } else if (leftChild instanceof ASTStringLiteral) {
            this.transformStartsWithOperator(rightChild, (ASTStringLiteral)leftChild, builder);
        } else {
            throw new JexlException((JexlNode)node, EXPECTED_STRING_LITERAL);
        }
        return data;
    }

    protected Object visit(ASTReferenceExpression node, Object data) {
        ((SelectorExpressionBuilder)((Object)data)).appendExpression(() -> {
            Object object2 = node.childrenAccept((ParserVisitor)this, data);
        });
        return data;
    }

    protected Object visit(ASTIdentifier node, Object data) {
        ((SelectorExpressionBuilder)((Object)data)).appendField(node.getName());
        return data;
    }

    protected Object visit(ASTStringLiteral node, Object data) {
        ((SelectorExpressionBuilder)((Object)data)).appendTerm((Term)new ExactTerm(node.getLiteral()));
        return data;
    }

    protected Object visit(ASTReference node, Object data) {
        ASTIdentifierAccess subRef = (ASTIdentifierAccess)node.jjtGetChild(1);
        ((SelectorExpressionBuilder)((Object)data)).appendField(subRef.getName());
        return data;
    }

    protected SelectorExpressionBuilder transformOperator(JexlNode node, Operand operator, SelectorExpressionBuilder builder) {
        JexlNode leftChild = node.jjtGetChild(0);
        JexlNode rightChild = node.jjtGetChild(1);
        leftChild.jjtAccept((ParserVisitor)this, (Object)builder);
        builder.appendOperand(operator);
        rightChild.jjtAccept((ParserVisitor)this, (Object)builder);
        return builder;
    }

    private SelectorExpressionBuilder transformStartsWithOperator(JexlNode node, ASTStringLiteral literal, SelectorExpressionBuilder builder) {
        node.jjtAccept((ParserVisitor)this, (Object)builder);
        builder.appendOperand(Operand.EQ);
        builder.appendTerm((Term)new WildcardTerm(literal.getLiteral()));
        return builder;
    }

    protected SelectorExpressionBuilder transformMatchesOperator(JexlNode node, SelectorExpressionBuilder builder) {
        String pattern;
        JexlNode leftChild = node.jjtGetChild(0);
        JexlNode rightChild = node.jjtGetChild(1);
        builder.appendField(((ASTIdentifier)leftChild).getName());
        builder.appendOperand(Operand.REGEX);
        if (rightChild instanceof ASTStringLiteral) {
            pattern = ((ASTStringLiteral)rightChild).getLiteral();
            if (pattern.charAt(0) != '^') {
                if (pattern.charAt(pattern.length() - 1) == '$') {
                    pattern = StringUtils.removeEnd((String)pattern, (String)"$");
                }
                pattern = String.format("(^|{)(%s)(}|$)", pattern);
            } else {
                pattern = StringUtils.removeStart((String)pattern, (String)"^");
                if ((pattern = TOKEN_START_REGEX + pattern).charAt(pattern.length() - 1) == '$') {
                    pattern = StringUtils.removeEnd((String)pattern, (String)"$");
                    pattern = String.valueOf(pattern) + TOKEN_END_REGEX;
                }
            }
        } else {
            throw new JexlException(node, EXPECTED_STRING_LITERAL);
        }
        builder.appendTerm((Term)new ExactTerm(pattern));
        return builder;
    }

    private SelectorExpressionBuilder transformNotEqualsOperator(JexlNode node, ASTStringLiteral literal, SelectorExpressionBuilder builder) {
        builder.appendExpression(() -> {
            node.jjtAccept((ParserVisitor)this, (Object)builder);
            builder.appendOperand(Operand.EQ);
            builder.appendTerm((Term)NullTerm.INSTANCE);
            builder.appendOperand(Operand.OR);
            node.jjtAccept((ParserVisitor)this, (Object)builder);
            builder.appendOperand(Operand.NOT_EQ);
            literal.jjtAccept((ParserVisitor)this, (Object)builder);
        });
        return builder;
    }
}

