/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.query.postgres;

import com.sonatype.nexus.distributed.internal.search.sql.query.SearchDatabase;
import com.sonatype.nexus.distributed.internal.search.sql.query.postgres.FulltextSearchColumn;
import com.sonatype.nexus.distributed.internal.search.sql.query.postgres.PostgresSearchColumn;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.rest.sql.SearchField;

@Named
@Singleton
public class PostgresSearchDB
implements SearchDatabase {
    private final Map<SearchField, PostgresSearchColumn> columns = Collections.unmodifiableMap(PostgresSearchDB.columns());

    @Inject
    public PostgresSearchDB() {
    }

    public Optional<PostgresSearchColumn> getColumn(SearchField field) {
        return Optional.ofNullable(this.columns.get(field));
    }

    @Override
    public Optional<String> getSortColumn(SearchField field) {
        return Optional.ofNullable(field).map(this.columns::get).flatMap(PostgresSearchColumn::getSortColumnName);
    }

    private static Map<SearchField, PostgresSearchColumn> columns() {
        EnumMap<SearchField, PostgresSearchColumn> columns = new EnumMap<SearchField, PostgresSearchColumn>(SearchField.class);
        columns.put(SearchField.FORMAT, FulltextSearchColumn.builder().withColumn("tsvector_format").withExactMatchColumn("format").withSortColumn("format").build());
        columns.put(SearchField.REPOSITORY_NAME, new PostgresSearchColumn("search_repository_name"));
        columns.put(SearchField.COMPONENT_ID, new PostgresSearchColumn("component_id"));
        columns.put(SearchField.COMPONENT_KIND, new PostgresSearchColumn("component_kind"));
        columns.put(SearchField.NAMESPACE, FulltextSearchColumn.builder().withColumn("tsvector_namespace").withExactMatchColumn("namespace").withSortColumn("namespace").build());
        columns.put(SearchField.NAME, FulltextSearchColumn.builder().withColumn("tsvector_search_component_name").withExactMatchColumn("search_component_name").withSortColumn("tsvector_search_component_name").build());
        columns.put(SearchField.VERSION, FulltextSearchColumn.builder().withColumn("tsvector_version").withExactMatchColumn("version").withSortColumn("normalised_version").build());
        columns.put(SearchField.PRERELEASE, new PostgresSearchColumn("prerelease"));
        columns.put(SearchField.KEYWORDS, new FulltextSearchColumn("keywords"));
        columns.put(SearchField.FORMAT_FIELD_1, FulltextSearchColumn.builder().withColumn("format_field_values_1").withSortColumn("attributes").build());
        columns.put(SearchField.FORMAT_FIELD_2, FulltextSearchColumn.builder().withColumn("format_field_values_2").withSortColumn("attributes").build());
        columns.put(SearchField.FORMAT_FIELD_3, FulltextSearchColumn.builder().withColumn("format_field_values_3").withSortColumn("attributes").build());
        columns.put(SearchField.FORMAT_FIELD_4, FulltextSearchColumn.builder().withColumn("format_field_values_4").withSortColumn("attributes").build());
        columns.put(SearchField.FORMAT_FIELD_5, FulltextSearchColumn.builder().withColumn("format_field_values_5").withSortColumn("attributes").build());
        columns.put(SearchField.FORMAT_FIELD_6, FulltextSearchColumn.builder().withColumn("format_field_values_6").withSortColumn("attributes").build());
        columns.put(SearchField.FORMAT_FIELD_7, FulltextSearchColumn.builder().withColumn("format_field_values_7").withSortColumn("attributes").build());
        columns.put(SearchField.MD5, new FulltextSearchColumn("md5"));
        columns.put(SearchField.SHA1, new FulltextSearchColumn("sha1"));
        columns.put(SearchField.SHA256, new FulltextSearchColumn("sha256"));
        columns.put(SearchField.SHA512, new FulltextSearchColumn("sha512"));
        columns.put(SearchField.TAGS, new FulltextSearchColumn("tsvector_tags"));
        columns.put(SearchField.PATHS, new FulltextSearchColumn("paths"));
        columns.put(SearchField.UPLOADERS, new FulltextSearchColumn("uploaders"));
        columns.put(SearchField.UPLOADER_IPS, new FulltextSearchColumn("uploader_ips"));
        return columns;
    }
}

