/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.query.postgres;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.search.sql.query.SearchConditionFactory;
import com.sonatype.nexus.distributed.internal.search.sql.query.SqlSearchQueryCondition;
import com.sonatype.nexus.distributed.internal.search.sql.query.postgres.PostgresFulltextSearchConditionBuilder;
import com.sonatype.nexus.distributed.internal.search.sql.query.postgres.PostgresSearchDB;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.search.sql.query.syntax.Expression;

@Named
@Singleton
public class PostgresSearchConditionFactory
implements SearchConditionFactory {
    private final PostgresSearchDB db;

    @Inject
    public PostgresSearchConditionFactory(PostgresSearchDB db) {
        this.db = (PostgresSearchDB)Preconditions.checkNotNull((Object)db);
    }

    @Override
    public SqlSearchQueryCondition build(Expression expression) {
        return new PostgresFulltextSearchConditionBuilder(this.db).build(expression);
    }
}

