/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.query.postgres;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.sonatype.nexus.distributed.internal.search.sql.query.SqlSearchQueryCondition;
import com.sonatype.nexus.distributed.internal.search.sql.query.postgres.PostgresSearchColumn;
import com.sonatype.nexus.distributed.internal.search.sql.query.postgres.PostgresSearchDB;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.search.sql.query.syntax.Expression;
import org.sonatype.nexus.repository.search.sql.query.syntax.NullTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.Operand;
import org.sonatype.nexus.repository.search.sql.query.syntax.SqlClause;
import org.sonatype.nexus.repository.search.sql.query.syntax.SqlPredicate;
import org.sonatype.nexus.repository.search.sql.query.syntax.StringTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.Term;
import org.sonatype.nexus.repository.search.sql.query.syntax.TermCollection;
import org.sonatype.nexus.rest.ValidationErrorsException;

abstract class PostgresSearchConditionBuilder
extends ComponentSupport {
    protected static final String BRACKET_CLOSE = ")";
    protected static final String BRACKET_OPEN = "(";
    protected final PostgresSearchDB db;
    protected final Map<String, String> parameters = new HashMap<String, String>();
    protected final ValidationErrorsException errors = new ValidationErrorsException();
    private int parameterIndex = 0;

    PostgresSearchConditionBuilder(PostgresSearchDB db) {
        this.db = (PostgresSearchDB)Preconditions.checkNotNull((Object)db);
    }

    public SqlSearchQueryCondition build(Expression expression) {
        Optional<String> query = this.process(expression).map(CharSequence::toString).map(String::trim);
        if (!this.errors.getValidationErrors().isEmpty()) {
            throw this.errors;
        }
        return new SqlSearchQueryCondition(query.orElse(""), this.parameters);
    }

    private Optional<CharSequence> process(Expression expression) {
        Optional<CharSequence> query;
        if (expression instanceof SqlClause) {
            query = this.process((SqlClause)expression);
        } else if (expression instanceof SqlPredicate) {
            query = this.process((SqlPredicate)expression);
        } else {
            this.errors.withError("Unknown expression " + expression);
            query = Optional.empty();
        }
        return query;
    }

    private Optional<CharSequence> process(SqlClause clause) {
        if (clause.expressions().size() == 1) {
            return this.process((Expression)Iterables.getOnlyElement((Iterable)clause.expressions()));
        }
        String operator = clause.operand() == Operand.AND ? " AND " : " OR ";
        String expression = clause.expressions().stream().map(this::process).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining(operator, BRACKET_OPEN, BRACKET_CLOSE));
        return Optional.of(expression);
    }

    private Optional<CharSequence> process(SqlPredicate predicate) {
        Optional<PostgresSearchColumn> optColumn = this.db.getColumn(predicate.getSearchField());
        if (!optColumn.isPresent()) {
            this.log.error("Unknown column for search {}", (Object)predicate.getSearchField());
            return Optional.empty();
        }
        PostgresSearchColumn column = optColumn.get();
        Collection<StringTerm> terms = PostgresSearchConditionBuilder.toList(predicate.getTerm());
        Operand op = predicate.operand();
        if (!op.supportsMultiple() && terms.size() != 1) {
            this.log.debug("Unsupported number of terms for operand {} for {} with terms {}", new Object[]{op, column, terms});
            this.errors.withError(String.format("Unsupported number of terms for operand %s for %s with terms %s", op, column, terms));
            return Optional.empty();
        }
        return this.createQuery(column, op, terms);
    }

    protected Optional<CharSequence> createQuery(PostgresSearchColumn column, Operand op, Collection<StringTerm> terms) {
        return this.createExactPredicate(column, op, terms);
    }

    private Optional<CharSequence> createExactPredicate(PostgresSearchColumn column, Operand op, Collection<StringTerm> terms) {
        switch (op) {
            case EQ: {
                if (PostgresSearchConditionBuilder.isNullTerm(terms)) {
                    return Optional.of(String.valueOf(column.getExactColumnName()) + " IS NULL");
                }
                return this.createSimpleExpression(column, "=", (StringTerm)Iterables.getOnlyElement(terms));
            }
            case NOT_EQ: {
                if (PostgresSearchConditionBuilder.isNullTerm(terms)) {
                    return Optional.of(String.valueOf(column.getExactColumnName()) + " IS NOT NULL");
                }
                return this.createSimpleExpression(column, "<>", (StringTerm)Iterables.getOnlyElement(terms));
            }
            case REGEX: {
                return this.createSimpleExpression(column, "~", (StringTerm)Iterables.getOnlyElement(terms));
            }
            case IN: {
                return this.createInExpression(column, terms);
            }
        }
        this.errors.withError("Unexpected operator " + op + " for column " + column);
        return Optional.empty();
    }

    private Optional<CharSequence> createSimpleExpression(PostgresSearchColumn column, String operator, StringTerm term) {
        String param = this.param(column.getExactColumnName());
        StringBuilder sb = new StringBuilder();
        sb.append(column.getExactColumnName());
        sb.append(' ').append(operator).append(' ');
        sb.append(PostgresSearchConditionBuilder.placeholder(param));
        this.parameters.put(param, term.get());
        return Optional.of(sb);
    }

    private Optional<CharSequence> createInExpression(PostgresSearchColumn column, Collection<StringTerm> terms) {
        Map<String, String> predicateParams = terms.stream().collect(Collectors.toMap(__ -> this.param(column.getExactColumnName()), StringTerm::get));
        String predicate = predicateParams.keySet().stream().sorted().map(PostgresSearchConditionBuilder::placeholder).collect(Collectors.joining(", ", String.valueOf(column.getExactColumnName()) + " IN (", BRACKET_CLOSE));
        this.parameters.putAll(predicateParams);
        return Optional.of(predicate);
    }

    protected String param(String postgresSearchColumn) {
        return String.valueOf(postgresSearchColumn) + this.parameterIndex++;
    }

    protected static String placeholder(String parameterName) {
        return "#{filterParams." + parameterName + "}";
    }

    protected static Collection<StringTerm> toList(Term term) {
        if (term instanceof TermCollection) {
            return ((TermCollection)term).get();
        }
        return Collections.singleton((StringTerm)term);
    }

    private static boolean isNullTerm(Collection<StringTerm> terms) {
        return terms.stream().allMatch(NullTerm.class::isInstance);
    }
}

