/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.query.postgres;

import java.util.Optional;

class PostgresSearchColumn {
    private final Optional<String> columnName;
    private final Optional<String> sortColumnName;

    PostgresSearchColumn(String columnName) {
        this(columnName, columnName);
    }

    PostgresSearchColumn(String columnName, String sortColumnName) {
        this.columnName = Optional.of(columnName);
        this.sortColumnName = Optional.ofNullable(sortColumnName);
    }

    protected PostgresSearchColumn(Optional<String> columnName, Optional<String> sortColumnName) {
        this.columnName = columnName;
        this.sortColumnName = sortColumnName;
    }

    String getExactColumnName() {
        return this.columnName.orElseGet(this::getFullTextColumn);
    }

    String getFullTextColumn() {
        throw new UnsupportedOperationException(this.columnName + " does not support full text");
    }

    Optional<String> getSortColumnName() {
        return this.sortColumnName;
    }

    boolean supportsExact() {
        return this.columnName.isPresent();
    }

    boolean supportsFulltext() {
        return false;
    }
}

