/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.query.postgres;

import com.google.common.collect.Iterables;
import com.sonatype.nexus.distributed.internal.search.sql.query.postgres.PostgresSearchColumn;
import com.sonatype.nexus.distributed.internal.search.sql.query.postgres.PostgresSearchConditionBuilder;
import com.sonatype.nexus.distributed.internal.search.sql.query.postgres.PostgresSearchDB;
import java.util.Collection;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.search.sql.query.syntax.ExactTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.LenientTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.Operand;
import org.sonatype.nexus.repository.search.sql.query.syntax.StringTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.WildcardTerm;

public class PostgresFulltextSearchConditionBuilder
extends PostgresSearchConditionBuilder {
    private static final String TOKENIZING_PATTERN = "[.\\-/]";
    private static final String PLAINTO_TSQUERY_FORMAT = "PLAINTO_TSQUERY('simple', %s)";
    private static final String PHRASETO_TSQUERY_FORMAT = "PHRASETO_TSQUERY('simple', %s)";
    private static final String WILDCARD_TS_QUERY_FORMAT = "TO_TSQUERY('simple', PLAINTO_TSQUERY('simple', %s)::text || ':*')";
    private static final Predicate<String> SHOULD_REMOVE_SEGMENTS = Pattern.compile("^(.+\\..+\\..*\\d+.*)$").asPredicate().or(Pattern.compile("^(.+\\..+\\..)$").asPredicate());

    PostgresFulltextSearchConditionBuilder(PostgresSearchDB db) {
        super(db);
    }

    @Override
    protected Optional<CharSequence> createQuery(PostgresSearchColumn column, Operand op, Collection<StringTerm> terms) {
        if (PostgresFulltextSearchConditionBuilder.requiresFulltext(column, terms)) {
            return this.createFullText(column, op, terms);
        }
        return super.createQuery(column, op, terms);
    }

    private static boolean requiresFulltext(PostgresSearchColumn column, Collection<StringTerm> terms) {
        if (column.supportsFulltext()) {
            return !column.supportsExact() || terms.size() != 1 || !(Iterables.getOnlyElement(terms) instanceof ExactTerm);
        }
        return false;
    }

    private Optional<CharSequence> createFullText(PostgresSearchColumn column, Operand operand, Collection<StringTerm> terms) {
        String operator;
        if (terms.stream().map(StringTerm::get).allMatch(Strings2::isBlank)) {
            return Optional.empty();
        }
        switch (operand) {
            case EQ: {
                operator = " && ";
                break;
            }
            case ANY: {
                operator = " || ";
                break;
            }
            case REGEX: {
                return super.createQuery(column, operand, terms);
            }
            default: {
                this.errors.withError("Unsupported operand " + operand + " for terms " + terms);
                return Optional.empty();
            }
        }
        CharSequence query = this.createExpression(column, operator, terms, UnaryOperator.identity());
        Collection requiringTokenization = terms.stream().filter(term -> !term.get().startsWith("/")).filter(term -> !term.get().equals(PostgresFulltextSearchConditionBuilder.tokenize(term.get()))).collect(Collectors.toList());
        if (requiringTokenization.isEmpty() || column.getFullTextColumn().equals("paths")) {
            return Optional.of(String.format("%s @@ (%s)", column.getFullTextColumn(), query));
        }
        CharSequence permissions = this.createExpression(column, operator, requiringTokenization, PostgresFulltextSearchConditionBuilder::tokenize);
        return Optional.of(String.format("%s @@ ((%s) || (%s))", column.getFullTextColumn(), query, permissions));
    }

    private CharSequence createExpression(PostgresSearchColumn column, String operator, Collection<StringTerm> terms, UnaryOperator<String> termMutator) {
        StringJoiner predicate = new StringJoiner(operator);
        for (StringTerm term : terms) {
            String param = this.param(column.getFullTextColumn());
            String value = (String)termMutator.apply(term.get());
            if (term instanceof LenientTerm) {
                predicate.add(this.handleLenient(value, param));
                continue;
            }
            if (term instanceof ExactTerm) {
                predicate.add(this.handleExact(value, param));
                continue;
            }
            if (term instanceof WildcardTerm) {
                predicate.add(this.handleWildcard(value, param));
                continue;
            }
            this.log.debug("Unexpected term type {}", (Object)term);
        }
        return predicate.toString();
    }

    private String handleLenient(String term, String param) {
        if (PostgresFulltextSearchConditionBuilder.isRemoveLastWords(term)) {
            return this.handleWildcard(term, param);
        }
        this.parameters.put(param, term);
        return String.format(PLAINTO_TSQUERY_FORMAT, PostgresFulltextSearchConditionBuilder.placeholder(param));
    }

    private String handleExact(String term, String param) {
        this.parameters.put(param, term);
        return String.format(PHRASETO_TSQUERY_FORMAT, PostgresFulltextSearchConditionBuilder.placeholder(param));
    }

    private String handleWildcard(String term, String param) {
        String value = PostgresFulltextSearchConditionBuilder.isRemoveLastWords(term) ? PostgresFulltextSearchConditionBuilder.trimStringAfterSecondDot(term) : term;
        this.parameters.put(param, value);
        return String.format(WILDCARD_TS_QUERY_FORMAT, PostgresFulltextSearchConditionBuilder.placeholder(param));
    }

    private static String trimStringAfterSecondDot(String value) {
        String[] split = value.split("\\.");
        return String.valueOf(split[0]) + '.' + split[1];
    }

    private static String tokenize(String token) {
        return token.replaceAll(TOKENIZING_PATTERN, " ").trim();
    }

    public static boolean isRemoveLastWords(String value) {
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("/")) {
            return false;
        }
        return SHOULD_REMOVE_SEGMENTS.test(value);
    }
}

