/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.query.postgres;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.search.sql.query.postgres.PostgresSearchColumn;
import java.util.Optional;
import javax.annotation.Nullable;

class FulltextSearchColumn
extends PostgresSearchColumn {
    private final String fulltextColumn;

    FulltextSearchColumn(String fulltextColumn) {
        this(fulltextColumn, null);
    }

    FulltextSearchColumn(String fulltextColumn, String sortColumnName) {
        this(fulltextColumn, null, sortColumnName);
    }

    FulltextSearchColumn(String fulltextColumn, @Nullable String exactMatchColumn, @Nullable String sortColumnName) {
        super(Optional.ofNullable(exactMatchColumn), Optional.ofNullable(sortColumnName));
        this.fulltextColumn = (String)Preconditions.checkNotNull((Object)fulltextColumn);
    }

    @Override
    String getFullTextColumn() {
        return this.fulltextColumn;
    }

    @Override
    boolean supportsFulltext() {
        return true;
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private String columnName;
        private String sortColumnName;
        private String exactMatchColumn;

        Builder() {
        }

        Builder withColumn(String name) {
            this.columnName = name;
            return this;
        }

        Builder withSortColumn(String sortColumnName) {
            this.sortColumnName = sortColumnName;
            return this;
        }

        Builder withExactMatchColumn(String exactMatchColumn) {
            this.exactMatchColumn = exactMatchColumn;
            return this;
        }

        FulltextSearchColumn build() {
            return new FulltextSearchColumn((String)Preconditions.checkNotNull((Object)this.columnName), this.exactMatchColumn, this.sortColumnName);
        }
    }
}

